/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.Gdx;
import nl.colorize.multimedialib.math.Point;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.KeyCode;

public class GDXInput
implements InputDevice {
    private Point pointer = new Point(0.0f, 0.0f);
    private boolean pointerPressed = false;
    private boolean pointerReleased = false;

    protected GDXInput() {
    }

    public void update() {
        this.updatePointerStatus();
    }

    private void updatePointerStatus() {
        boolean currentState = Gdx.input.isTouched();
        if (currentState) {
            this.pointerPressed = true;
            this.pointerReleased = false;
        } else if (this.pointerPressed) {
            this.pointerPressed = false;
            this.pointerReleased = true;
        } else {
            this.pointerPressed = false;
            this.pointerReleased = false;
        }
    }

    @Override
    public Point getPointer() {
        this.pointer.set(Gdx.input.getX(), Gdx.input.getY());
        return this.pointer;
    }

    @Override
    public boolean isPointerPressed() {
        return this.pointerPressed;
    }

    @Override
    public boolean isPointerReleased() {
        return this.pointerReleased;
    }

    @Override
    public boolean isKeyboardAvailable() {
        return false;
    }

    @Override
    public boolean isKeyPressed(KeyCode keyCode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isKeyReleased(KeyCode keyCode) {
        throw new UnsupportedOperationException();
    }
}

