/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import nl.colorize.multimedialib.graphics.Audio;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.TrueTypeFont;
import nl.colorize.multimedialib.math.MathUtils;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.libgdx.GDXSound;
import nl.colorize.multimedialib.renderer.libgdx.GDXTexture;
import nl.colorize.util.LogHelper;
import nl.colorize.util.ResourceFile;
import org.teavm.apachecommons.io.Charsets;

public class GDXMediaLoader
implements MediaLoader {
    private List<GDXTexture> loadedTextures = new ArrayList<GDXTexture>();
    private List<GDXSound> loadedSounds = new ArrayList<GDXSound>();
    private Map<ColorRGB, Texture> colorTextureCache = new HashMap<ColorRGB, Texture>();
    private static final int COLOR_TEXTURE_SIZE = 8;
    private static final Logger LOGGER = LogHelper.getLogger(GDXMediaLoader.class);

    @Override
    public Image loadImage(FilePointer file) {
        Texture texture = new Texture(this.getFileHandle(file));
        GDXTexture gdxTexture = new GDXTexture(texture);
        this.loadedTextures.add(gdxTexture);
        if (!this.checkTextureDimensions(texture)) {
            LOGGER.warning("Texture dimensions might not be supported by current platform: " + file.getPath() + " (" + texture.getWidth() + "x" + texture.getHeight() + ")");
        }
        return gdxTexture;
    }

    private boolean checkTextureDimensions(Texture texture) {
        return MathUtils.isPowerOfTwo(texture.getWidth()) && MathUtils.isPowerOfTwo(texture.getHeight()) && texture.getWidth() == texture.getHeight();
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        Sound sound = Gdx.audio.newSound(this.getFileHandle(file));
        GDXSound gdxSound = new GDXSound(sound);
        this.loadedSounds.add(gdxSound);
        return gdxSound;
    }

    public Texture getColorTexture(ColorRGB color) {
        Texture colorTexture = this.colorTextureCache.get(color);
        if (colorTexture == null) {
            colorTexture = this.generateColorTexture(color);
            this.colorTextureCache.put(color, colorTexture);
        }
        return colorTexture;
    }

    private Texture generateColorTexture(ColorRGB color) {
        Pixmap pixelData = new Pixmap(8, 8, Pixmap.Format.RGBA8888);
        pixelData.setColor(this.toColor(color));
        pixelData.fillRectangle(0, 0, 8, 8);
        return new Texture(pixelData);
    }

    private FileHandle getFileHandle(FilePointer file) {
        return Gdx.files.internal(file.getPath());
    }

    private Color toColor(ColorRGB color) {
        return new Color((float)color.getR() / 255.0f, (float)color.getG() / 255.0f, (float)color.getB() / 255.0f, 1.0f);
    }

    @Override
    public TrueTypeFont loadFont(String fontFamily, FilePointer file) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String loadText(FilePointer file) {
        ResourceFile resourceFile = new ResourceFile(file.getPath());
        try {
            return resourceFile.read(Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new MediaException("Cannot load file: " + file);
        }
    }

    public void dispose() {
        this.loadedTextures.forEach(texture -> texture.dispose());
        this.loadedTextures.clear();
        this.loadedSounds.forEach(sound -> sound.dispose());
        this.loadedSounds.clear();
        this.colorTextureCache.values().forEach(colorTexture -> colorTexture.dispose());
        this.colorTextureCache.clear();
    }

    @Override
    public boolean containsResourceFile(FilePointer file) {
        return new ResourceFile(file.getPath()).exists();
    }
}

