/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import nl.colorize.multimedialib.graphics.Align;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.graphics.TrueTypeFont;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.AbstractRenderer;
import nl.colorize.multimedialib.renderer.ApplicationData;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsContext;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.renderer.java2d.StandardApplicationData;
import nl.colorize.multimedialib.renderer.libgdx.GDXApplicationData;
import nl.colorize.multimedialib.renderer.libgdx.GDXInput;
import nl.colorize.multimedialib.renderer.libgdx.GDXMediaLoader;
import nl.colorize.multimedialib.renderer.libgdx.GDXTexture;
import nl.colorize.util.Platform;

public class GDXRenderer
extends AbstractRenderer
implements ApplicationListener,
GraphicsContext {
    private Application app;
    private GDXInput input;
    private GDXMediaLoader mediaLoader;
    private int framerate;
    private OrthographicCamera camera;
    private SpriteBatch batch;
    private static final Transform DEFAULT_TRANSFORM = new Transform();
    private static final List<Integer> SUPPORTED_FRAMERATES = ImmutableList.of((Object)20, (Object)25, (Object)30, (Object)60);
    private static final int CIRCLE_PRECISION = 16;

    public GDXRenderer(Canvas canvas, int framerate, WindowOptions windowOptions) {
        super(canvas);
        Preconditions.checkArgument((boolean)SUPPORTED_FRAMERATES.contains(framerate), (Object)("Framerate is not supported: " + framerate));
        this.framerate = framerate;
        this.app = this.initApplication(framerate, windowOptions);
    }

    private Application initApplication(int framerate, WindowOptions windowOptions) {
        Canvas canvas = this.getCanvas();
        Lwjgl3ApplicationConfiguration config = new Lwjgl3ApplicationConfiguration();
        config.setWindowedMode(canvas.getWidth(), canvas.getHeight());
        config.setDecorated(true);
        config.setIdleFPS(framerate);
        config.setTitle(windowOptions.getTitle());
        if (windowOptions.hasIcon()) {
            config.setWindowIcon(Files.FileType.Internal, new String[]{windowOptions.getIconFile().getPath()});
        }
        return new Lwjgl3Application((ApplicationListener)this, config);
    }

    public void create() {
        this.input = new GDXInput();
        this.mediaLoader = new GDXMediaLoader();
        this.camera = new OrthographicCamera();
        this.resize(this.getCanvas().getWidth(), this.getCanvas().getHeight());
        this.batch = new SpriteBatch();
    }

    public void dispose() {
        this.mediaLoader.dispose();
        this.mediaLoader = null;
        this.batch.dispose();
        this.batch = null;
    }

    public void resize(int width, int height) {
        this.getCanvas().resize(width, height);
        this.camera.setToOrtho(false, (float)width, (float)height);
    }

    public void pause() {
    }

    public void resume() {
    }

    public void render() {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.camera.update();
        this.input.update();
        this.batch.setProjectionMatrix(this.camera.combined);
        this.batch.begin();
        this.performFrameUpdate();
        this.performFrameRender();
        this.batch.end();
    }

    private void performFrameUpdate() {
        float frameTime = 1.0f / (float)this.framerate;
        this.notifyUpdateCallbacks(frameTime);
    }

    private void performFrameRender() {
        this.notifyRenderCallbacks(this);
    }

    @Override
    public void drawBackground(ColorRGB backgroundColor) {
        Canvas canvas = this.getCanvas();
        Rect background = new Rect(0.0f, 0.0f, canvas.getWidth(), canvas.getHeight());
        this.drawRect(background, backgroundColor, null);
    }

    @Override
    public void drawRect(Rect rect, ColorRGB color, Transform transform) {
        if (transform == null) {
            transform = DEFAULT_TRANSFORM;
        }
        Texture colorTexture = this.mediaLoader.getColorTexture(color);
        TextureRegion colorTextureRegion = new TextureRegion(colorTexture, 0, 0, colorTexture.getWidth(), colorTexture.getHeight());
        this.draw(rect.getCenterX(), rect.getCenterY(), rect.getWidth(), rect.getHeight(), color, colorTextureRegion, transform);
    }

    @Override
    public void drawCircle(Circle circle, ColorRGB color, Transform transform) {
        Polygon polygon = Polygon.createCircle(circle.getCenter().getX(), circle.getCenter().getY(), circle.getRadius(), 16);
        this.drawPolygon(polygon, color, transform);
    }

    @Override
    public void drawPolygon(Polygon polygon, ColorRGB color, Transform transform) {
        float minX = polygon.getPointX(0);
        float minY = polygon.getPointY(1);
        float maxX = polygon.getPointX(0);
        float maxY = polygon.getPointY(1);
        for (int i = 1; i < polygon.getNumPoints(); ++i) {
            minX = Math.min(minX, polygon.getPointX(i));
            minY = Math.min(minY, polygon.getPointY(i));
            maxX = Math.max(maxX, polygon.getPointX(i));
            maxY = Math.max(maxY, polygon.getPointY(i));
        }
        this.drawRect(new Rect(minX, minY, maxX - minX, maxY - minY), color, transform);
    }

    @Override
    public void drawImage(Image image, float x, float y, Transform transform) {
        int width = image.getWidth();
        int height = image.getHeight();
        TextureRegion textureRegion = ((GDXTexture)image).getTextureRegion();
        if (transform == null) {
            transform = DEFAULT_TRANSFORM;
        }
        this.draw(x, y, width, height, ColorRGB.WHITE, textureRegion, transform);
    }

    private void draw(float x, float y, float width, float height, ColorRGB color, TextureRegion texture, Transform transform) {
        float canvasX = x - width / 2.0f;
        float canvasY = Math.abs(y - (float)this.getCanvas().getHeight()) - height / 2.0f;
        float originY = Math.abs(y - (float)this.getCanvas().getHeight());
        this.batch.setColor((float)color.getR() / 255.0f, (float)color.getG() / 255.0f, (float)color.getB() / 255.0f, (float)transform.getAlpha() / 100.0f);
        this.batch.draw(texture, canvasX, canvasY, x, originY, width, height, (float)transform.getScaleX() / 100.0f, (float)transform.getScaleY() / 100.0f, (float)transform.getRotation());
    }

    @Override
    public void drawText(String text, TrueTypeFont font, float x, float y, Align align, Transform transform) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputDevice getInputDevice() {
        return this.input;
    }

    @Override
    public MediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    @Override
    public ApplicationData getApplicationData(String appName) {
        if (Platform.isWindows() || Platform.isMac()) {
            return new StandardApplicationData(appName);
        }
        return new GDXApplicationData(appName);
    }
}

