/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import nl.colorize.multimedialib.graphics.Align;
import nl.colorize.multimedialib.graphics.Animation;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.Sprite;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.graphics.TrueTypeFont;
import nl.colorize.multimedialib.math.Point;
import nl.colorize.multimedialib.renderer.GraphicsContext;
import nl.colorize.multimedialib.scene.Renderable;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.util.animation.Timeline;

public abstract class Effect
implements Updatable,
Renderable {
    private Timeline timeline;
    private List<Consumer<Float>> modifiers;
    private Point position;
    private Transform transform;

    private Effect(Timeline timeline) {
        this.timeline = timeline;
        this.modifiers = new ArrayList<Consumer<Float>>();
        this.position = new Point(0.0f, 0.0f);
        this.transform = new Transform();
    }

    public void modify(Consumer<Float> modifier) {
        this.modifiers.add(modifier);
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public Point getPosition() {
        return this.position;
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
    }

    public Transform getTransform() {
        return this.transform;
    }

    @Override
    public void update(float deltaTime) {
        this.timeline.onFrame(deltaTime);
        for (Consumer<Float> modifier : this.modifiers) {
            modifier.accept(Float.valueOf(this.timeline.getValue()));
        }
    }

    public boolean isCompleted() {
        return this.timeline.isCompleted();
    }

    @Override
    public abstract void render(GraphicsContext var1);

    public static Effect forSprite(final Sprite sprite, Timeline timeline) {
        return new Effect(timeline){

            @Override
            public void render(GraphicsContext graphics) {
                graphics.drawSprite(sprite, this.getPosition().getX(), this.getPosition().getY(), this.getTransform());
            }
        };
    }

    public static Effect forSpriteX(Sprite sprite, Timeline timeline) {
        Effect effect = Effect.forSprite(sprite, timeline);
        effect.modify(value -> effect.getPosition().setX(value.floatValue()));
        return effect;
    }

    public static Effect forSpriteY(Sprite sprite, Timeline timeline) {
        Effect effect = Effect.forSprite(sprite, timeline);
        effect.modify(value -> effect.getPosition().setY(value.floatValue()));
        return effect;
    }

    public static Effect forSpriteAlpha(Sprite sprite, Timeline timeline) {
        Effect effect = Effect.forSprite(sprite, timeline);
        effect.modify(value -> effect.getTransform().setAlpha(Math.round(value.floatValue())));
        return effect;
    }

    public static Effect forAnimation(Animation anim, Timeline timeline) {
        Sprite sprite = new Sprite();
        sprite.addState("_effect", anim);
        return Effect.forSprite(sprite, timeline);
    }

    public static Effect forImage(Image image, Timeline timeline) {
        Sprite sprite = new Sprite();
        sprite.addState("_effect", image);
        return Effect.forSprite(sprite, timeline);
    }

    public static Effect forText(final String text, final TrueTypeFont font, final Align align, Timeline timeline) {
        return new Effect(timeline){

            @Override
            public void render(GraphicsContext graphics) {
                graphics.drawText(text, font, this.getPosition().getX(), this.getPosition().getY(), align, this.getTransform());
            }
        };
    }

    public static Effect forTextAlpha(String text, TrueTypeFont font, Align align, Timeline timeline) {
        Effect effect = Effect.forText(text, font, align, timeline);
        effect.modify(value -> effect.getTransform().setAlpha(Math.round(value.floatValue())));
        return effect;
    }
}

