/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.RotatingBuffer;
import nl.colorize.multimedialib.renderer.ApplicationData;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsContext;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.scene.Renderable;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.util.Stopwatch;

public class SceneManager
implements Updatable,
Renderable,
SceneContext {
    private Renderer renderer;
    private Scene activeScene;
    private Scene requestedScene;
    private Stopwatch fpsTimer;
    private RotatingBuffer fpsBuffer;
    private RotatingBuffer frameTimeBuffer;
    private static final int FPS_MEASUREMENT_BUFFER_SIZE = 100;

    private SceneManager(Renderer renderer) {
        this.renderer = renderer;
        this.fpsTimer = new Stopwatch();
        this.fpsBuffer = new RotatingBuffer(100);
        this.frameTimeBuffer = new RotatingBuffer(100);
    }

    @Override
    public void changeScene(Scene requestedScene) {
        Preconditions.checkState((this.requestedScene == null ? 1 : 0) != 0, (Object)("Another scene has already been requested: " + requestedScene));
        this.requestedScene = requestedScene;
    }

    public Scene getActiveScene() {
        return this.activeScene;
    }

    @Override
    public void update(float deltaTime) {
        if (this.requestedScene != null) {
            this.activeScene = this.requestedScene;
            this.requestedScene = null;
            this.activeScene.start(this);
        }
        Stopwatch frameTimer = new Stopwatch();
        frameTimer.tick();
        if (this.activeScene != null) {
            this.activeScene.update(deltaTime);
        }
        long actualFrameTime = frameTimer.tick();
        this.frameTimeBuffer.add(actualFrameTime);
    }

    @Override
    public void render(GraphicsContext graphics) {
        if (this.activeScene != null) {
            long fpsValue = this.fpsTimer.tick();
            this.fpsBuffer.add(fpsValue);
            this.activeScene.render(graphics);
        }
    }

    @Override
    public Canvas getCanvas() {
        return this.renderer.getCanvas();
    }

    @Override
    public InputDevice getInputDevice() {
        return this.renderer.getInputDevice();
    }

    @Override
    public MediaLoader getMediaLoader() {
        return this.renderer.getMediaLoader();
    }

    @Override
    public ApplicationData getApplicationData(String appName) {
        return this.renderer.getApplicationData(appName);
    }

    @Override
    public float getAverageFPS() {
        return 1000.0f / this.fpsBuffer.getAverageValue();
    }

    @Override
    public float getAverageFrameTime() {
        return this.frameTimeBuffer.getAverageValue();
    }

    public static SceneManager attach(Renderer renderer) {
        SceneManager sceneManager = new SceneManager(renderer);
        renderer.addUpdateCallback(sceneManager);
        renderer.addRenderCallback(sceneManager);
        return sceneManager;
    }
}

