/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import com.google.common.base.Preconditions;
import java.awt.image.BufferedImage;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.Rect;

public class AWTImage
implements Image {
    private BufferedImage image;

    public AWTImage(BufferedImage image) {
        this.image = image;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public Image getRegion(Rect region) {
        BufferedImage subImage = this.image.getSubimage(Math.round(region.getX()), Math.round(region.getY()), Math.round(region.getWidth()), Math.round(region.getHeight()));
        return new AWTImage(subImage);
    }

    @Override
    public ColorRGB getColor(int x, int y) {
        Preconditions.checkArgument((x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight() ? 1 : 0) != 0, (Object)("Invalid coordinate: " + x + ", " + y));
        int rgba = this.image.getRGB(x, y);
        return new ColorRGB(rgba);
    }

    @Override
    public int getAlpha(int x, int y) {
        Preconditions.checkArgument((x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight() ? 1 : 0) != 0, (Object)("Invalid coordinate: " + x + ", " + y));
        int rgba = this.image.getRGB(x, y);
        int alpha = rgba >> 24 & 0xFF;
        return Math.round((float)alpha / 2.55f);
    }
}

