/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import nl.colorize.multimedialib.graphics.Align;
import nl.colorize.multimedialib.graphics.AlphaTransform;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsContext;
import nl.colorize.multimedialib.renderer.java2d.AWTImage;
import nl.colorize.multimedialib.renderer.java2d.StandardMediaLoader;
import nl.colorize.util.swing.Utils2D;

public class Java2DGraphicsContext
implements GraphicsContext {
    private Canvas canvas;
    private Graphics2D g2;
    private StandardMediaLoader mediaLoader;
    private Map<ColorRGB, Color> colorCache;
    private Map<String, BufferedImage> maskCache;
    private static final Transform NULL_TRANSFORM = new Transform();

    protected Java2DGraphicsContext(Canvas canvas, StandardMediaLoader mediaLoader) {
        this.canvas = canvas;
        this.mediaLoader = mediaLoader;
        this.colorCache = new HashMap<ColorRGB, Color>();
        this.maskCache = new HashMap<String, BufferedImage>();
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas;
    }

    public void bind(Graphics2D g2) {
        this.g2 = g2;
    }

    public void dispose() {
        if (this.g2 != null) {
            this.g2.dispose();
            this.g2 = null;
        }
    }

    @Override
    public void drawBackground(ColorRGB backgroundColor) {
        int width = this.canvas.toScreenX(this.canvas.getWidth());
        int height = this.canvas.toScreenY(this.canvas.getHeight());
        this.g2.setColor(this.convertColor(backgroundColor));
        this.g2.fillRect(0, 0, width, height);
    }

    @Override
    public void drawRect(Rect rect, ColorRGB color, AlphaTransform alpha) {
        int screenX = this.canvas.toScreenX(rect.getX());
        int screenY = this.canvas.toScreenY(rect.getY());
        int screenWidth = this.canvas.toScreenX(rect.getEndX()) - screenX;
        int screenHeight = this.canvas.toScreenY(rect.getEndY()) - screenY;
        Composite originalComposite = this.g2.getComposite();
        this.applyAlphaComposite(alpha);
        this.g2.setColor(this.convertColor(color));
        this.g2.fillRect(screenX, screenY, screenWidth, screenHeight);
        this.g2.setComposite(originalComposite);
    }

    @Override
    public void drawCircle(Circle circle, ColorRGB color, AlphaTransform alpha) {
        int screenX = this.canvas.toScreenX(circle.getCenterX() - circle.getRadius());
        int screenY = this.canvas.toScreenY(circle.getCenterY() - circle.getRadius());
        int screenWidth = this.canvas.toScreenX(circle.getCenterX() + circle.getRadius()) - screenX;
        int screenHeight = this.canvas.toScreenY(circle.getCenterY() + circle.getRadius()) - screenY;
        Composite originalComposite = this.g2.getComposite();
        this.applyAlphaComposite(alpha);
        this.g2.setColor(this.convertColor(color));
        this.g2.fillOval(screenX, screenY, screenWidth, screenHeight);
        this.g2.setComposite(originalComposite);
    }

    @Override
    public void drawPolygon(Polygon polygon, ColorRGB color, AlphaTransform alpha) {
        int[] px = new int[polygon.getNumPoints()];
        int[] py = new int[polygon.getNumPoints()];
        for (int i = 0; i < polygon.getNumPoints(); ++i) {
            px[i] = this.canvas.toScreenX(polygon.getPointX(i));
            py[i] = this.canvas.toScreenY(polygon.getPointY(i));
        }
        Composite originalComposite = this.g2.getComposite();
        this.applyAlphaComposite(alpha);
        this.g2.setColor(this.convertColor(color));
        this.g2.fillPolygon(px, py, polygon.getNumPoints());
        this.g2.setComposite(originalComposite);
    }

    @Override
    public void drawImage(Image image, float x, float y, Transform transform) {
        this.drawImage(((AWTImage)image).getImage(), Math.round(x), Math.round(y), transform);
    }

    private void drawImage(BufferedImage image, int x, int y, Transform transform) {
        if (transform == null) {
            transform = NULL_TRANSFORM;
        }
        Composite originalComposite = this.g2.getComposite();
        this.applyAlphaComposite(transform);
        AffineTransform transform2D = this.applyTransform(x, y, image.getWidth(), image.getHeight(), transform);
        this.g2.drawImage(image, transform2D, null);
        if (transform.getMask() != null) {
            BufferedImage maskImage = this.prepareMaskImage(image, transform.getMask());
            this.g2.drawImage(maskImage, transform2D, null);
        }
        this.g2.setComposite(originalComposite);
    }

    @Override
    public void drawText(String text, TTFont font, float x, float y, Align align, AlphaTransform alpha) {
        int screenX = this.canvas.toScreenX(x);
        int screenY = this.canvas.toScreenY(y);
        Font awtFont = this.mediaLoader.getFont(font);
        int estimatedWidth = this.g2.getFontMetrics(awtFont).stringWidth(text);
        Composite originalComposite = this.g2.getComposite();
        this.applyAlphaComposite(alpha);
        this.g2.setColor(this.convertColor(font.getColor()));
        this.g2.setFont(awtFont);
        if (align == Align.CENTER) {
            this.g2.drawString(text, (float)screenX - (float)estimatedWidth / 2.0f, (float)screenY);
        } else if (align == Align.RIGHT) {
            this.g2.drawString(text, screenX - estimatedWidth, screenY);
        } else {
            this.g2.drawString(text, screenX, screenY);
        }
        this.g2.setComposite(originalComposite);
    }

    private AffineTransform applyTransform(int x, int y, int width, int height, Transform transform) {
        int screenX = this.canvas.toScreenX(x);
        int screenY = this.canvas.toScreenY(y);
        float scaleX = this.canvas.getZoomLevel() * ((float)transform.getScaleX() / 100.0f);
        float scaleY = this.canvas.getZoomLevel() * ((float)transform.getScaleY() / 100.0f);
        int screenWidth = (int)((float)width * scaleX);
        int screenHeight = (int)((float)height * scaleY);
        AffineTransform transform2D = new AffineTransform();
        transform2D.setToIdentity();
        transform2D.translate((float)screenX - (float)screenWidth / 2.0f, (float)screenY - (float)screenHeight / 2.0f);
        transform2D.rotate(transform.getRotationInRadians(), (double)screenWidth / 2.0, (double)screenHeight / 2.0);
        transform2D.scale(scaleX, scaleY);
        return transform2D;
    }

    private void applyAlphaComposite(AlphaTransform transform) {
        if (transform != null && transform.getAlpha() != 100) {
            AlphaComposite alphaComposite = AlphaComposite.SrcOver.derive((float)transform.getAlpha() / 100.0f);
            this.g2.setComposite(alphaComposite);
        }
    }

    private Color convertColor(ColorRGB color) {
        Color result = this.colorCache.get(color);
        if (result == null) {
            result = new Color(color.getR(), color.getG(), color.getB());
            this.colorCache.put(color, result);
        }
        return result;
    }

    private BufferedImage prepareMaskImage(BufferedImage original, ColorRGB mask) {
        String cacheKey = original.getWidth() + "x" + original.getHeight();
        BufferedImage maskImage = this.maskCache.get(cacheKey);
        if (maskImage == null) {
            maskImage = new BufferedImage(original.getWidth(), original.getHeight(), 2);
            this.maskCache.put(cacheKey, maskImage);
        }
        Graphics2D g2 = Utils2D.createGraphics((BufferedImage)maskImage, (boolean)true, (boolean)false);
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, maskImage.getWidth(), maskImage.getHeight());
        g2.setComposite(AlphaComposite.SrcOver);
        g2.setColor(this.convertColor(mask));
        g2.drawImage(original, 0, 0, original.getWidth(), original.getHeight(), null);
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.fillRect(0, 0, maskImage.getWidth(), maskImage.getHeight());
        g2.dispose();
        return maskImage;
    }
}

