/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.util.LogHelper;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public abstract class CommandLineTool {
    private PrintStream usageStream = System.err;
    private static final Logger LOGGER = LogHelper.getLogger(CommandLineTool.class);

    public final void start(String[] args) {
        CmdLineParser cmdParser = new CmdLineParser((Object)this);
        cmdParser.getProperties().withUsageWidth(80);
        try {
            cmdParser.parseArgument(args);
            this.run();
        }
        catch (CmdLineException e) {
            this.printUsage(cmdParser);
            LOGGER.info(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while running tool", e);
        }
    }

    private void printUsage(CmdLineParser cmdParser) {
        this.usageStream.println(this.getDescription());
        this.usageStream.println();
        this.usageStream.println("Arguments:");
        cmdParser.printUsage((OutputStream)this.usageStream);
        this.usageStream.println();
    }

    public abstract void run();

    protected File parseInputFile(String path) {
        File inputFile = new File(path);
        if (!inputFile.exists()) {
            throw new IllegalArgumentException("File '" + path + "' not found");
        }
        return inputFile;
    }

    protected File parseInputDirectory(String path) {
        File inputDirectory = new File(path);
        if (!inputDirectory.exists()) {
            throw new IllegalArgumentException("Directory '" + path + "' not found");
        }
        if (!inputDirectory.isDirectory()) {
            throw new IllegalArgumentException("'" + path + "' is not a directory");
        }
        return inputDirectory;
    }

    protected File parseOutputFile(String path) {
        File outputFile = new File(path);
        if (outputFile.exists()) {
            throw new IllegalArgumentException("File '" + path + "' already exists");
        }
        return outputFile;
    }

    protected File parseOutputDirectory(String path, boolean allowExisting) {
        File outputDirectory = new File(path);
        if (!allowExisting && outputDirectory.exists()) {
            throw new IllegalArgumentException("Directory '" + path + "' already exists");
        }
        if (outputDirectory.exists() && !outputDirectory.isDirectory()) {
            throw new IllegalArgumentException("'" + path + "' is not a directory");
        }
        return outputDirectory;
    }

    protected String getDescription() {
        return this.getClass().getSimpleName();
    }
}

