//-----------------------------------------------------------------------------
// Colorize MultimediaLib
// Copyright 2009-2020 Colorize
// Apache license (http://www.colorize.nl/code_license.txt)
//-----------------------------------------------------------------------------

package nl.colorize.multimedialib.renderer.teavm;

import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.scene.SceneManager;
import nl.colorize.multimedialib.tool.DemoApplication;

/**
 * Launcher for the TeaVM version of the demo application. This class will be
 * transpiled to JavaScript and then called from the browser.
 */
public class TeaDemo {

    private static final int CANVAS_WIDTH = 800;
    private static final int CANVAS_HEIGHT = 600;
    private static final boolean FLEXIBLE_CANVAS = true;
    private static final FilePointer VERIFICATION_FILE = new FilePointer("verification-instructions.txt");

    public static void main(String[] args) {
        Browser.log("MultimediaLib - TeaVM Demo");

        Canvas canvas = new Canvas(CANVAS_WIDTH, CANVAS_HEIGHT, FLEXIBLE_CANVAS);
        TeaRenderer renderer = new TeaRenderer(canvas);

        SceneManager sceneManager = SceneManager.attach(renderer);
        DemoApplication demo = new DemoApplication(renderer);
        sceneManager.changeScene(demo);

        String verificationInstructions = renderer.getMediaLoader().loadText(VERIFICATION_FILE);
        Browser.log(verificationInstructions);
    }
}
