/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.Rect;

public class Canvas {
    private int preferredWidth;
    private int preferredHeight;
    private boolean flexible;
    private int screenWidth;
    private int screenHeight;
    private int offsetX;
    private int offsetY;

    public Canvas(int preferredWidth, int preferredHeight, boolean flexible) {
        Preconditions.checkArgument((preferredWidth > 0 && preferredHeight > 0 ? 1 : 0) != 0, (Object)("Invalid canvas dimensions: " + preferredWidth + "x" + preferredHeight));
        this.preferredWidth = preferredWidth;
        this.preferredHeight = preferredHeight;
        this.flexible = flexible;
        this.screenWidth = preferredWidth;
        this.screenHeight = preferredHeight;
        this.offsetX = 0;
        this.offsetY = 0;
    }

    public void resizeScreen(int screenWidth, int screenHeight) {
        Preconditions.checkArgument((screenWidth > 0 && screenHeight > 0 ? 1 : 0) != 0, (Object)("Invalid screen dimensions: " + screenWidth + "x" + screenHeight));
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public void offsetScreen(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public int getWidth() {
        return Math.round((float)(this.screenWidth - this.offsetX) / this.getZoomLevel());
    }

    public int getHeight() {
        return Math.round((float)(this.screenHeight - this.offsetY) / this.getZoomLevel());
    }

    public Rect getBounds() {
        return new Rect(0.0f, 0.0f, this.getWidth(), this.getHeight());
    }

    public float getZoomLevel() {
        if (this.flexible) {
            return 1.0f;
        }
        float horizontalZoom = (float)this.screenWidth / (float)this.preferredWidth;
        float verticalZoom = (float)this.screenHeight / (float)this.preferredHeight;
        return Math.min(horizontalZoom, verticalZoom);
    }

    public float toCanvasX(int screenX) {
        return (float)(screenX - this.offsetX) / this.getZoomLevel();
    }

    public float toCanvasY(int screenY) {
        return (float)(screenY - this.offsetY) / this.getZoomLevel();
    }

    public float toScreenX(float canvasX) {
        return canvasX * this.getZoomLevel() + (float)this.offsetX;
    }

    public float toScreenY(float canvasY) {
        return canvasY * this.getZoomLevel() + (float)this.offsetY;
    }

    public String toString() {
        double factor = Math.pow(10.0, 1.0);
        String formattedZoom = String.valueOf((double)Math.round((double)this.getZoomLevel() * factor) / factor);
        return this.getWidth() + "x" + this.getHeight() + " @ " + formattedZoom + "x";
    }
}

