/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.renderer.ApplicationData;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.teavm.AnimationFrameCallback;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphicsContext;
import nl.colorize.multimedialib.renderer.teavm.TeaInputDevice;
import nl.colorize.multimedialib.renderer.teavm.TeaLocalStorage;
import nl.colorize.multimedialib.renderer.teavm.TeaMediaLoader;
import nl.colorize.multimedialib.scene.Renderable;
import nl.colorize.multimedialib.scene.Updatable;

public class TeaRenderer
implements Renderer,
AnimationFrameCallback {
    private Canvas canvas;
    private TeaGraphicsContext graphics;
    private TeaInputDevice inputDevice;
    private TeaMediaLoader mediaLoader;
    private TeaLocalStorage localStorage;
    private List<Updatable> updateCallbacks;
    private List<Renderable> renderCallbacks;
    private static final int HTML_CANVAS_ANIMATION_FRAMERATE = 60;

    public TeaRenderer(Canvas canvas) {
        this.canvas = canvas;
        this.graphics = new TeaGraphicsContext(canvas);
        this.inputDevice = new TeaInputDevice(canvas);
        this.mediaLoader = new TeaMediaLoader();
        this.localStorage = new TeaLocalStorage();
        this.updateCallbacks = new ArrayList<Updatable>();
        this.renderCallbacks = new ArrayList<Renderable>();
        Browser.renderFrame(this);
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas;
    }

    @Override
    public InputDevice getInputDevice() {
        return this.inputDevice;
    }

    @Override
    public MediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    @Override
    public ApplicationData getApplicationData(String appName) {
        return this.localStorage;
    }

    @Override
    public void addUpdateCallback(Updatable callback) {
        this.updateCallbacks.add(callback);
    }

    @Override
    public void addRenderCallback(Renderable callback) {
        this.renderCallbacks.add(callback);
    }

    @Override
    public void onRenderFrame() {
        float deltaTime = 0.016666668f;
        this.updateCanvas();
        this.inputDevice.update(deltaTime);
        for (Updatable updateCallback : this.updateCallbacks) {
            updateCallback.update(deltaTime);
        }
        for (Renderable renderCallback : this.renderCallbacks) {
            renderCallback.render(this.graphics);
        }
    }

    private void updateCanvas() {
        int canvasWidth = Math.round(Browser.getCanvasWidth());
        int canvasHeight = Math.round(Browser.getCanvasHeight());
        if (canvasWidth > 0 && canvasHeight > 0) {
            this.canvas.resizeScreen(canvasWidth, canvasHeight);
        }
    }
}

