/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.function.Supplier;
import java.util.logging.Logger;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.renderer.java2d.Java2DRenderer;
import nl.colorize.multimedialib.renderer.libgdx.GDXRenderer;
import nl.colorize.multimedialib.scene.SceneManager;
import nl.colorize.multimedialib.tool.CommandLineTool;
import nl.colorize.multimedialib.tool.DemoApplication;
import nl.colorize.util.LogHelper;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.swing.ApplicationMenuListener;
import nl.colorize.util.swing.Popups;
import org.kohsuke.args4j.Option;

public class DemoLauncher
extends CommandLineTool
implements ApplicationMenuListener {
    @Option(name="-renderer", required=true, usage="Renderer to use for the demo (java2d, gdx)")
    public String rendererName;
    @Option(name="-framerate", required=false, usage="Demo framerate, default is 30 fps")
    private int framerate = 60;
    @Option(name="-canvas", required=false, usage="Uses a fixed canvas size to display graphics")
    private boolean canvas = false;
    @Option(name="-verification", required=false, usage="Prints instructions for verification")
    public boolean verification = false;
    private static final ResourceFile VERIFICATION_FILE = new ResourceFile("verification-instructions.txt");
    private static final Logger LOGGER = LogHelper.getLogger(DemoLauncher.class);

    public static void main(String[] args) {
        DemoLauncher demo = new DemoLauncher();
        demo.start(args);
    }

    @Override
    public void run() {
        Renderer renderer = this.createRenderer();
        SceneManager sceneManager = SceneManager.attach(renderer);
        LOGGER.info("Launching demo application using " + renderer.getClass().getName());
        DemoApplication demo = new DemoApplication(renderer);
        sceneManager.changeScene(demo);
        if (this.verification) {
            this.printVerificationInstructions();
        }
    }

    private Renderer createRenderer() {
        ImmutableMap possibilities = ImmutableMap.of((Object)"java2d", this::createJava2DRenderer, (Object)"gdx", this::createGDXRenderer);
        Preconditions.checkArgument((boolean)possibilities.containsKey(this.rendererName), (Object)("Renderer not supported: " + this.rendererName));
        return (Renderer)((Supplier)possibilities.get(this.rendererName)).get();
    }

    private Java2DRenderer createJava2DRenderer() {
        return new Java2DRenderer(this.getCanvas(), this.framerate, this.getWindowOptions());
    }

    private GDXRenderer createGDXRenderer() {
        return new GDXRenderer(this.getCanvas(), this.framerate, this.getWindowOptions());
    }

    private Canvas getCanvas() {
        return new Canvas(800, 600, !this.canvas);
    }

    private WindowOptions getWindowOptions() {
        WindowOptions windowOptions = new WindowOptions("MultimediaLib - Demo");
        windowOptions.setAppMenuListener(this);
        return windowOptions;
    }

    private void printVerificationInstructions() {
        try {
            String instructions = VERIFICATION_FILE.read(Charsets.UTF_8);
            LOGGER.info("\n\n" + instructions);
        }
        catch (IOException e) {
            throw new AssertionError("Cannot load verification instructions", e);
        }
    }

    public void onQuit() {
        System.exit(0);
    }

    public void onAbout() {
        Popups.message(null, (String)"MultimediaLib - demo application");
    }
}

