/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nl.colorize.multimedialib.graphics.Animation;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.renderer.Updatable;

public class Sprite
implements Updatable {
    private Map<String, Animation> availableStates = new HashMap<String, Animation>();
    private String currentState = null;
    private float timeInCurrentState = 0.0f;

    public void addState(String name, Animation graphics) {
        Preconditions.checkArgument((!this.availableStates.containsKey(name) ? 1 : 0) != 0, (Object)("Duplicate state: " + name));
        Preconditions.checkArgument((graphics != null ? 1 : 0) != 0, (Object)("No graphics for state: " + name));
        this.availableStates.put(name, graphics);
        if (this.currentState == null) {
            this.changeState(name);
        }
    }

    public void addState(String name, Image stateGraphics) {
        this.addState(name, new Animation(stateGraphics));
    }

    @Override
    public void update(float deltaTime) {
        Preconditions.checkState((this.currentState != null ? 1 : 0) != 0, (Object)"Sprite does not have graphics yet");
        this.timeInCurrentState += deltaTime;
    }

    public void changeState(String stateName) {
        Preconditions.checkArgument((boolean)this.availableStates.containsKey(stateName), (Object)("Unknown state: " + stateName));
        if (this.currentState == null || !this.currentState.equals(stateName)) {
            this.currentState = stateName;
            this.timeInCurrentState = 0.0f;
        }
    }

    public void resetState() {
        this.timeInCurrentState = 0.0f;
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public float getTimeInCurrentState() {
        return this.timeInCurrentState;
    }

    public Set<String> getAvailableStates() {
        return ImmutableSet.copyOf(this.availableStates.keySet());
    }

    public boolean hasState(String stateName) {
        return this.availableStates.containsKey(stateName);
    }

    public Animation getStateGraphics(String stateName) {
        Animation graphics = this.availableStates.get(stateName);
        Preconditions.checkArgument((graphics != null ? 1 : 0) != 0, (Object)("Unknown state: " + stateName));
        return graphics;
    }

    public Image getCurrentGraphics() {
        Preconditions.checkState((this.currentState != null ? 1 : 0) != 0, (Object)"Sprite does not have graphics yet");
        Animation graphics = this.availableStates.get(this.currentState);
        return graphics.getFrameAtTime(this.timeInCurrentState);
    }

    public int getCurrentWidth() {
        return this.getCurrentGraphics().getWidth();
    }

    public int getCurrentHeight() {
        return this.getCurrentGraphics().getHeight();
    }

    public Sprite copy() {
        Sprite copy = new Sprite();
        for (Map.Entry<String, Animation> entry : this.availableStates.entrySet()) {
            copy.addState(entry.getKey(), entry.getValue());
        }
        copy.changeState(this.currentState);
        return copy;
    }
}

