/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import nl.colorize.multimedialib.graphics.ColorRGB;

public class TTFont {
    private String family;
    private int size;
    private ColorRGB color;
    private boolean bold;
    public static final int DEFAULT_SIZE = 12;

    public TTFont(String family, int size, ColorRGB color) {
        this.family = family;
        this.size = size;
        this.color = color;
        this.bold = false;
    }

    public String getFamily() {
        return this.family;
    }

    public int getSize() {
        return this.size;
    }

    public ColorRGB getColor() {
        return this.color;
    }

    public boolean isBold() {
        return this.bold;
    }

    public TTFont derive(int newSize) {
        return new TTFont(this.family, newSize, this.color);
    }

    public TTFont derive(ColorRGB newColor) {
        return new TTFont(this.family, this.size, newColor);
    }

    public TTFont derive(int newSize, ColorRGB newColor) {
        return new TTFont(this.family, newSize, newColor);
    }

    public TTFont bold() {
        TTFont derived = new TTFont(this.family, this.size, this.color);
        derived.bold = true;
        return derived;
    }

    public boolean equals(Object o) {
        if (o instanceof TTFont) {
            TTFont other = (TTFont)o;
            return this.family.equals(other.family) && this.size == other.size;
        }
        return false;
    }

    public int hashCode() {
        return this.family.hashCode();
    }

    public String toString() {
        return this.family;
    }
}

