/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.MathUtils;
import nl.colorize.multimedialib.math.Point;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.util.Formatting;

public class Canvas {
    private int preferredWidth;
    private int preferredHeight;
    private boolean flexible;
    private float minZoom;
    private float maxZoom;
    private int screenWidth;
    private int screenHeight;
    private int offsetX;
    private int offsetY;

    private Canvas(int preferredWidth, int preferredHeight, boolean flexible) {
        Preconditions.checkArgument((preferredWidth > 0 && preferredHeight > 0 ? 1 : 0) != 0, (Object)("Invalid canvas dimensions: " + preferredWidth + "x" + preferredHeight));
        this.preferredWidth = preferredWidth;
        this.preferredHeight = preferredHeight;
        this.flexible = flexible;
        this.minZoom = 0.0f;
        this.maxZoom = 0.0f;
        this.screenWidth = preferredWidth;
        this.screenHeight = preferredHeight;
        this.offsetX = 0;
        this.offsetY = 0;
    }

    public void resizeScreen(int screenWidth, int screenHeight) {
        Preconditions.checkArgument((screenWidth > 0 && screenHeight > 0 ? 1 : 0) != 0, (Object)("Invalid screen dimensions: " + screenWidth + "x" + screenHeight));
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public void offsetScreen(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public int getWidth() {
        return Math.round((float)this.screenWidth / this.getZoomLevel());
    }

    public int getHeight() {
        return Math.round((float)this.screenHeight / this.getZoomLevel());
    }

    public Rect getBounds() {
        return new Rect(0.0f, 0.0f, this.getWidth(), this.getHeight());
    }

    public Point getCenter() {
        return new Point((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
    }

    public float getZoomLevel() {
        float horizontalZoom = (float)this.screenWidth / (float)this.preferredWidth;
        float verticalZoom = (float)this.screenHeight / (float)this.preferredHeight;
        float zoom = Math.min(horizontalZoom, verticalZoom);
        if (this.isReponsive()) {
            return MathUtils.clamp(zoom, this.minZoom, this.maxZoom);
        }
        if (this.flexible) {
            return 1.0f;
        }
        return zoom;
    }

    private boolean isReponsive() {
        return this.flexible && this.minZoom > 0.0f && this.maxZoom > 0.0f;
    }

    public float toCanvasX(int screenX) {
        return (float)(screenX - this.offsetX) / this.getZoomLevel();
    }

    public float toCanvasY(int screenY) {
        return (float)(screenY - this.offsetY) / this.getZoomLevel();
    }

    public float toScreenX(float canvasX) {
        return canvasX * this.getZoomLevel() + (float)this.offsetX;
    }

    public float toScreenY(float canvasY) {
        return canvasY * this.getZoomLevel() + (float)this.offsetY;
    }

    public String toString() {
        String zoom = Formatting.numberFormat((float)this.getZoomLevel(), (int)1);
        return this.getWidth() + "x" + this.getHeight() + " @ " + zoom + "x";
    }

    public static Canvas fixed(int preferredWidth, int preferredHeight) {
        return new Canvas(preferredWidth, preferredHeight, false);
    }

    public static Canvas flexible(int initialWidth, int initialHeight) {
        return new Canvas(initialWidth, initialHeight, true);
    }

    public static Canvas responsive(int initialWidth, int initialHeight, float minZoom, float maxZoom) {
        Preconditions.checkArgument((minZoom >= 0.1f ? 1 : 0) != 0, (Object)("Invalid zoom level: " + minZoom));
        Preconditions.checkArgument((maxZoom >= 0.1f ? 1 : 0) != 0, (Object)("Invalid zoom level: " + maxZoom));
        Preconditions.checkArgument((maxZoom > minZoom ? 1 : 0) != 0, (Object)"Invalid zoom range");
        Canvas canvas = new Canvas(initialWidth, initialHeight, true);
        canvas.minZoom = minZoom;
        canvas.maxZoom = maxZoom;
        return canvas;
    }
}

