/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.Gdx;
import com.google.common.collect.ImmutableList;
import java.util.List;
import nl.colorize.multimedialib.math.Point;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.Updatable;

public class GDXInput
implements InputDevice,
Updatable {
    private Point pointer = new Point(0.0f, 0.0f);
    private boolean pointerPressed = false;
    private boolean pointerReleased = false;

    protected GDXInput() {
    }

    @Override
    public void update(float deltaTime) {
        this.pointer.set(Gdx.input.getX(), Gdx.input.getY());
        if (Gdx.input.isTouched()) {
            this.pointerPressed = true;
            this.pointerReleased = false;
        } else if (this.pointerPressed) {
            this.pointerPressed = false;
            this.pointerReleased = true;
        } else {
            this.pointerPressed = false;
            this.pointerReleased = false;
        }
    }

    @Override
    public List<Point> getPointers() {
        return ImmutableList.of((Object)this.pointer);
    }

    @Override
    public boolean isPointerPressed(Rect area) {
        return this.pointerPressed && area.contains(this.pointer);
    }

    @Override
    public boolean isPointerReleased(Rect area) {
        return this.pointerReleased && area.contains(this.pointer);
    }

    @Override
    public boolean isTouchAvailable() {
        return false;
    }

    @Override
    public boolean isKeyboardAvailable() {
        return false;
    }

    @Override
    public boolean isKeyPressed(KeyCode keyCode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isKeyReleased(KeyCode keyCode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String requestTextInput(String label, String initialValue) {
        throw new UnsupportedOperationException();
    }
}

