/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.Rect;

public class GDXTexture
implements Image {
    private Texture texture;
    private TextureRegion textureRegion;
    private Pixmap textureData;
    private Rect bounds;
    private boolean disposed;

    protected GDXTexture(Texture texture, Rect bounds) {
        float u1 = bounds.getX() / (float)texture.getWidth();
        float v1 = bounds.getY() / (float)texture.getHeight();
        float u2 = bounds.getEndX() / (float)texture.getWidth();
        float v2 = bounds.getEndY() / (float)texture.getHeight();
        this.texture = texture;
        this.textureRegion = new TextureRegion(texture, u1, v1, u2, v2);
        this.bounds = bounds;
        this.disposed = false;
    }

    protected GDXTexture(Texture texture) {
        this(texture, new Rect(0.0f, 0.0f, texture.getWidth(), texture.getHeight()));
    }

    public Texture getTexture() {
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0, (Object)"Texture has already been disposed");
        return this.texture;
    }

    public TextureRegion getTextureRegion() {
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0, (Object)"Texture has already been disposed");
        return this.textureRegion;
    }

    @Override
    public int getWidth() {
        return Math.round(this.bounds.getWidth());
    }

    @Override
    public int getHeight() {
        return Math.round(this.bounds.getHeight());
    }

    @Override
    public Image getRegion(Rect region) {
        return new GDXTexture(this.texture, region);
    }

    private void loadTextureData() {
        if (this.textureData == null) {
            this.textureData = this.texture.getTextureData().consumePixmap();
        }
    }

    @Override
    public ColorRGB getColor(int x, int y) {
        Preconditions.checkArgument((x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight() ? 1 : 0) != 0, (Object)("Invalid coordinate: " + x + ", " + y));
        this.loadTextureData();
        int rgba = this.textureData.getPixel(x, y);
        return new ColorRGB(rgba);
    }

    @Override
    public int getAlpha(int x, int y) {
        Preconditions.checkArgument((x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight() ? 1 : 0) != 0, (Object)("Invalid coordinate: " + x + ", " + y));
        this.loadTextureData();
        int rgba = this.textureData.getPixel(x, y);
        int alpha = rgba >> 24 & 0xFF;
        return Math.round((float)alpha / 2.55f);
    }

    public void dispose() {
        this.texture.dispose();
        this.disposed = true;
    }
}

