/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.renderer.GraphicsContext;
import nl.colorize.multimedialib.scene.Effect;
import nl.colorize.multimedialib.scene.Scene;

public class EffectManager
implements Scene {
    private List<Effect> effects = new ArrayList<Effect>();

    @Override
    public void start() {
        this.cancelAll();
    }

    public void play(Effect effect) {
        this.effects.add(effect);
    }

    public void cancel(Effect effect) {
        this.effects.remove(effect);
    }

    public void cancelAll() {
        this.effects.clear();
    }

    @Override
    public void update(float deltaTime) {
        Effect[] buffer;
        for (Effect effect : buffer = this.effects.toArray(new Effect[0])) {
            effect.update(deltaTime);
            if (!effect.isCompleted()) continue;
            this.effects.remove(effect);
        }
    }

    @Override
    public void render(GraphicsContext graphics) {
        for (Effect effect : this.effects) {
            effect.render(graphics);
        }
    }
}

