/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene.ui;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.graphics.Align;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.GraphicsContext;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.scene.ui.Widget;
import nl.colorize.multimedialib.scene.ui.WidgetStyle;

public class Button
extends Widget {
    private String label;
    private InputDevice input;
    private Runnable onClick;

    public Button(WidgetStyle style, String label) {
        super(style);
        this.label = label;
    }

    public Button(WidgetStyle style) {
        this(style, "");
    }

    public void setClickHandler(InputDevice input, Runnable onClick) {
        this.input = input;
        this.onClick = onClick;
    }

    @Override
    public void update(float deltaTime) {
        Preconditions.checkState((this.onClick != null ? 1 : 0) != 0, (Object)"Click handler has not been set");
        Image backgroundImage = this.getStyle().getBackground();
        Rect bounds = Rect.around(this.getX(), this.getY(), backgroundImage.getWidth(), backgroundImage.getHeight());
        if (this.input.isPointerReleased(bounds)) {
            this.onClick.run();
        }
    }

    @Override
    public void render(GraphicsContext graphics) {
        Image backgroundImage = this.getStyle().getBackground();
        TTFont font = this.getStyle().getFont();
        graphics.drawImage(backgroundImage, this.getX(), this.getY(), null);
        if (this.label != null && font != null) {
            graphics.drawText(this.label, font, this.getX(), this.getY() + (float)backgroundImage.getHeight() * 0.2f, Align.CENTER);
        }
    }
}

