/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene.ui;

import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.GraphicsContext;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.scene.ui.Widget;
import nl.colorize.multimedialib.scene.ui.WidgetStyle;

public class TextField
extends Widget {
    private String label;
    private String value;
    private InputDevice input;
    private Consumer<String> onChange;

    public TextField(WidgetStyle style, String label, String initialValue) {
        super(style);
        this.label = label;
        this.value = initialValue;
    }

    public TextField(WidgetStyle style, String label) {
        this(style, label, "");
    }

    public void setChangeHandler(InputDevice input, Consumer<String> onChange) {
        this.input = input;
        this.onChange = onChange;
    }

    @Override
    public void update(float deltaTime) {
        String enteredValue;
        Preconditions.checkArgument((this.input != null ? 1 : 0) != 0, (Object)"Change handler not set");
        Image backgroundImage = this.getStyle().getBackground();
        Rect bounds = Rect.around(this.getX(), this.getY(), backgroundImage.getWidth(), backgroundImage.getHeight());
        if (this.input.isPointerReleased(bounds) && (enteredValue = this.input.requestTextInput(this.label, this.value)) != null) {
            this.value = enteredValue;
            if (this.onChange != null) {
                this.onChange.accept(this.value);
            }
        }
    }

    @Override
    public void render(GraphicsContext graphics) {
        Image backgroundImage = this.getStyle().getBackground();
        graphics.drawImage(backgroundImage, this.getX(), this.getY());
        graphics.drawText(this.value, this.getStyle().getFont(), this.getX() - (float)backgroundImage.getWidth() * 0.4f, this.getY() + (float)backgroundImage.getHeight() * 0.2f);
    }

    public String getValue() {
        return this.value;
    }
}

