/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.function.Supplier;
import java.util.logging.Logger;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.java2d.Java2DRenderer;
import nl.colorize.multimedialib.renderer.java2d.WindowOptions;
import nl.colorize.multimedialib.renderer.libgdx.GDXRenderer;
import nl.colorize.multimedialib.scene.Application;
import nl.colorize.multimedialib.tool.CommandLineTool;
import nl.colorize.multimedialib.tool.DemoApplication;
import nl.colorize.util.LogHelper;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.swing.ApplicationMenuListener;
import nl.colorize.util.swing.Popups;
import org.kohsuke.args4j.Option;

public class DemoLauncher
extends CommandLineTool
implements ApplicationMenuListener {
    @Option(name="-renderer", required=true, usage="Renderer to use for the demo (java2d, gdx)")
    public String rendererName;
    @Option(name="-framerate", required=false, usage="Demo framerate, default is 60 fps")
    private int framerate = 60;
    @Option(name="-canvas", required=false, usage="Uses a fixed canvas size to display graphics")
    private boolean canvas = false;
    @Option(name="-orientationlock", required=false, usage="Restricts the demo to landscape orientation")
    public boolean orientationLock = false;
    @Option(name="-verification", required=false, usage="Prints instructions for verification")
    public boolean verification = false;
    private static final ResourceFile VERIFICATION_FILE = new ResourceFile("verification-instructions.txt");
    private static final Logger LOGGER = LogHelper.getLogger(DemoLauncher.class);

    public static void main(String[] args) {
        DemoLauncher demo = new DemoLauncher();
        demo.start(args);
    }

    @Override
    public void run() {
        Renderer renderer = this.createRenderer();
        LOGGER.info("Launching demo application using " + renderer.getClass().getName());
        Application app = new Application(renderer);
        if (this.orientationLock) {
            app.lockScreenOrientation();
        }
        app.changeScene(new DemoApplication(app));
        if (this.verification) {
            this.printVerificationInstructions();
        }
    }

    private Renderer createRenderer() {
        ImmutableMap possibilities = ImmutableMap.of((Object)"java2d", this::createJava2DRenderer, (Object)"gdx", this::createGDXRenderer);
        Preconditions.checkArgument((boolean)possibilities.containsKey(this.rendererName), (Object)("Renderer not supported: " + this.rendererName));
        return (Renderer)((Supplier)possibilities.get(this.rendererName)).get();
    }

    private Java2DRenderer createJava2DRenderer() {
        return new Java2DRenderer(this.getCanvas(), this.framerate, this.getWindowOptions());
    }

    private GDXRenderer createGDXRenderer() {
        return new GDXRenderer(this.getCanvas(), this.framerate, this.getWindowOptions());
    }

    private Canvas getCanvas() {
        if (this.canvas) {
            return Canvas.fixed(800, 600);
        }
        return Canvas.flexible(800, 600);
    }

    private WindowOptions getWindowOptions() {
        WindowOptions windowOptions = new WindowOptions("MultimediaLib - Demo");
        windowOptions.setAppMenuListener(this);
        return windowOptions;
    }

    private void printVerificationInstructions() {
        String instructions = VERIFICATION_FILE.read(Charsets.UTF_8);
        LOGGER.info("\n\n" + instructions);
    }

    public void onQuit() {
        System.exit(0);
    }

    public void onAbout() {
        Popups.message(null, (String)"MultimediaLib - demo application");
    }
}

