/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.google.common.base.Preconditions;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.multimedialib.tool.CommandLineTool;
import nl.colorize.util.LogHelper;
import nl.colorize.util.swing.Utils2D;
import org.kohsuke.args4j.Option;

public class ImageTileTool
extends CommandLineTool {
    @Option(name="-input", required=true, usage="Location of the input image")
    public File inputFile;
    @Option(name="-horizontal", required=true, usage="Times to tile the image horizontally")
    public int horizontal;
    @Option(name="-vertical", required=true, usage="Times to tile the image vertically")
    public int vertical;
    private static final Logger LOGGER = LogHelper.getLogger(ImageTileTool.class);

    public static void main(String[] args) {
        ImageTileTool tool = new ImageTileTool();
        tool.start(args);
    }

    @Override
    public void run() {
        try {
            BufferedImage image = Utils2D.loadImage((File)this.inputFile);
            BufferedImage result = this.tileImage(image);
            File outputFile = new File(this.inputFile.getParentFile(), this.inputFile.getName().replace(".png", "") + "-" + this.horizontal + "x" + this.vertical + ".png");
            Preconditions.checkState((!outputFile.exists() ? 1 : 0) != 0, (Object)("The file " + outputFile.getAbsolutePath() + " already exists"));
            Utils2D.savePNG((BufferedImage)result, (File)outputFile);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Cannot tile image", e);
        }
    }

    private BufferedImage tileImage(BufferedImage image) {
        BufferedImage result = new BufferedImage(image.getWidth() * this.horizontal, image.getHeight() * this.vertical, 2);
        Graphics2D g2 = Utils2D.createGraphics((BufferedImage)result, (boolean)false, (boolean)false);
        for (int i = 0; i < this.horizontal; ++i) {
            for (int j = 0; j < this.vertical; ++j) {
                g2.drawImage((Image)image, i * image.getWidth(), j * image.getHeight(), null);
            }
        }
        g2.dispose();
        return result;
    }
}

