//-----------------------------------------------------------------------------
// Colorize MultimediaLib
// Copyright 2009-2020 Colorize
// Apache license (http://www.apache.org/licenses/LICENSE-2.0)
//-----------------------------------------------------------------------------

package nl.colorize.multimedialib.scene.ui;

import nl.colorize.multimedialib.graphics.Align;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.renderer.GraphicsContext;

/**
 * Simple text label that is drawn at the specified coordinates.
 */
public class TextLabel extends Widget {

    private String text;
    private TTFont font;
    private Align align;

    public TextLabel(Location location, String text, TTFont font, Align align) {
        super(location);
        this.text = text;
        this.font = font;
        this.align = align;
    }

    public TextLabel(Location location, String text, TTFont font) {
        this(location, text, font, Align.LEFT);
    }

    @Override
    public void update(float deltaTime) {
    }

    @Override
    public void render(GraphicsContext graphics) {
        graphics.drawText(text, font, getX(), getY(), align);
    }
}
