//-----------------------------------------------------------------------------
// Colorize MultimediaLib
// Copyright 2009-2020 Colorize
// Apache license (http://www.apache.org/licenses/LICENSE-2.0)
//-----------------------------------------------------------------------------

package nl.colorize.multimedialib.scene.ui;

import nl.colorize.multimedialib.scene.SubSystem;

/**
 * Base class for all subsystems that emulate user interface widgets
 * (buttons, select boxes, text fields, etc.). This does not actually use the
 * platform's native user interface, but implements graphics and interaction
 * entirely in MultimediaLib so that the widgets works across all platforms.
 */
public abstract class Widget implements SubSystem {

    private Location location;

    public Widget(Location location) {
        this.location = location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return location;
    }

    protected float getX() {
        return location.getX();
    }

    protected float getY() {
        return location.getY();
    }
}
