/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import com.google.common.base.Splitter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import nl.colorize.multimedialib.graphics.Align;
import nl.colorize.multimedialib.graphics.AlphaTransform;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.TextFont;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Point;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.GraphicsContext;
import nl.colorize.util.LogHelper;

public class BitmapFont
implements TextFont {
    private Image image;
    private String family;
    private int size;
    private int lineHeight;
    private int base;
    private Map<Character, CharLayout> chars;
    private static final Splitter LINE_SPLITTER = Splitter.on((String)"\n");
    private static final Splitter TAG_SPLITTER = Splitter.on((String)" ").trimResults().omitEmptyStrings();
    private static final Logger LOGGER = LogHelper.getLogger(BitmapFont.class);

    private BitmapFont(Image image) {
        this.image = image;
        this.chars = new HashMap<Character, CharLayout>();
    }

    @Override
    public String getFamily() {
        return this.family;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    protected int getLineHeight() {
        return this.lineHeight;
    }

    protected int getBase() {
        return this.base;
    }

    protected Rect getBounds(char c) {
        CharLayout layout = this.chars.get(Character.valueOf(c));
        return layout.bounds;
    }

    @Override
    public BitmapFont derive(int newSize) {
        LOGGER.warning("Deriving fonts not supported for bitmap fonts");
        return this;
    }

    @Override
    public BitmapFont derive(ColorRGB newColor) {
        LOGGER.warning("Deriving fonts not supported for bitmap fonts");
        return this;
    }

    @Override
    public BitmapFont deriveBold() {
        LOGGER.warning("Deriving fonts not supported for bitmap fonts");
        return this;
    }

    public void draw(GraphicsContext context, String text, float x, float y, Align align, AlphaTransform alpha) {
        Transform transform = alpha != null ? alpha.toTransform() : null;
        int lineWidth = this.measureLineWidth(text);
        Point cursor = this.resetCursor(x, y, lineWidth, align);
        for (int i = 0; i < text.length(); ++i) {
            CharLayout layout = this.chars.get(Character.valueOf(text.charAt(i)));
            if (layout == null) continue;
            context.drawImage(layout.subImage, cursor.getX() + (float)layout.xOffset, cursor.getY() + (float)layout.yOffset, transform);
            cursor.setX(cursor.getX() + (float)layout.xAdvance);
        }
    }

    private Point resetCursor(float x, float y, int lineWidth, Align align) {
        switch (align) {
            case LEFT: {
                return new Point(x, y);
            }
            case RIGHT: {
                return new Point(x - (float)lineWidth, y);
            }
            case CENTER: {
                return new Point(x - (float)lineWidth / 2.0f, y);
            }
        }
        throw new IllegalArgumentException("Unknown text alignment: " + align);
    }

    private int measureLineWidth(String text) {
        int lineWidth = 0;
        for (int i = 0; i < text.length(); ++i) {
            CharLayout layout = this.chars.get(Character.valueOf(text.charAt(i)));
            if (layout == null) continue;
            lineWidth += layout.xAdvance;
        }
        return lineWidth;
    }

    public static BitmapFont parseFNT(Image image, String fntMetadata) {
        BitmapFont font = new BitmapFont(image);
        for (String line : LINE_SPLITTER.splitToList((CharSequence)fntMetadata)) {
            Map<String, String> tags = BitmapFont.parseTags(line);
            if (line.startsWith("info ")) {
                font.family = tags.get("face");
                font.size = Integer.parseInt(tags.get("size"));
                continue;
            }
            if (line.startsWith("common ")) {
                font.lineHeight = Integer.parseInt(tags.get("lineHeight"));
                font.base = Integer.parseInt(tags.get("base"));
                continue;
            }
            if (!line.startsWith("char ")) continue;
            CharLayout layout = new CharLayout();
            layout.bounds = new Rect(Integer.parseInt(tags.get("x")), Integer.parseInt(tags.get("y")), Integer.parseInt(tags.get("width")), Integer.parseInt(tags.get("height")));
            layout.subImage = image.getRegion(layout.bounds);
            layout.xOffset = Integer.parseInt(tags.get("xoffset"));
            layout.yOffset = Integer.parseInt(tags.get("yoffset"));
            layout.xAdvance = Integer.parseInt(tags.get("xadvance"));
            font.chars.put(Character.valueOf((char)Integer.parseInt(tags.get("id"))), layout);
        }
        return font;
    }

    private static Map<String, String> parseTags(String line) {
        HashMap<String, String> tags = new HashMap<String, String>();
        for (String tag : TAG_SPLITTER.splitToList((CharSequence)line)) {
            if (tag.indexOf(61) == -1) continue;
            String name = tag.substring(0, tag.indexOf(61));
            String value = tag.substring(tag.indexOf(61) + 1).replace("\"", "");
            tags.put(name, value);
        }
        return tags;
    }

    private static class CharLayout {
        private Image subImage;
        private Rect bounds;
        private int xOffset;
        private int yOffset;
        private int xAdvance;

        private CharLayout() {
        }
    }
}

