/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.multimedialib.renderer.InternetAccess;
import nl.colorize.multimedialib.renderer.WebSocketConnection;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Promise;
import nl.colorize.util.http.Headers;
import nl.colorize.util.http.Method;
import nl.colorize.util.http.PostData;
import nl.colorize.util.http.URLLoader;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class StandardInternetAccess
implements InternetAccess {
    private static final Logger LOGGER = LogHelper.getLogger(StandardInternetAccess.class);

    @Override
    public Promise<String> get(String url, Headers headers) {
        return this.send(Method.GET, url, headers, null);
    }

    @Override
    public Promise<String> post(String url, Headers headers, PostData body) {
        return this.send(Method.POST, url, headers, body);
    }

    public Promise<String> send(Method method, String url, Headers headers, PostData body) {
        URLLoader request = URLLoader.create((Method)method, (String)url, (Charset)StandardCharsets.UTF_8);
        request.addHeader("X-Requested-With", "MultimediaLib");
        request.addHeaders(headers);
        if (body != null) {
            request.setBody(body);
        }
        return new Promise(promise -> request.sendRequestPromise().then(response -> promise.resolve((Object)response.getBody())).thenCatch(arg_0 -> ((Promise)promise).reject(arg_0)));
    }

    @Override
    public boolean isWebSocketSupported() {
        return true;
    }

    @Override
    public WebSocketConnection connectWebSocket(String uri) {
        JavaWebSocketClient client = new JavaWebSocketClient(URI.create(uri));
        client.connect();
        return client;
    }

    private static class JavaWebSocketClient
    extends WebSocketClient
    implements WebSocketConnection {
        private AtomicBoolean connected = new AtomicBoolean(false);
        private List<String> sendBuffer = new CopyOnWriteArrayList<String>();
        private List<String> receiveBuffer = new CopyOnWriteArrayList<String>();

        public JavaWebSocketClient(URI uri) {
            super(uri);
        }

        public void onOpen(ServerHandshake handshake) {
            LOGGER.info("Web socket connection: " + handshake.getHttpStatusMessage());
            this.connected.set(true);
            super.send("__init");
            this.sendBuffer.forEach(x$0 -> super.send(x$0));
            this.sendBuffer.clear();
        }

        public void onClose(int code, String reason, boolean remote) {
            LOGGER.info("Web socket connection closed");
            this.connected.set(false);
        }

        public void onMessage(String message) {
            this.receiveBuffer.add(message);
        }

        public void onMessage(ByteBuffer buffer) {
            String message = new String(buffer.array(), Charsets.UTF_8);
            this.receiveBuffer.add(message);
        }

        public void onError(Exception e) {
            LOGGER.log(Level.WARNING, "Web socket error", e);
        }

        @Override
        public void send(String message) {
            if (this.connected.get()) {
                super.send(message);
            } else {
                this.sendBuffer.add(message);
            }
        }

        @Override
        public List<String> flushReceivedMessages() {
            ImmutableList received = ImmutableList.copyOf(this.receiveBuffer);
            this.receiveBuffer.clear();
            return received;
        }
    }
}

