/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.teavm.Browser;

public class TeaImage
implements Image {
    private String id;
    private String url;
    private Rect region;

    protected TeaImage(String id, String url, Rect region) {
        this.id = id;
        this.url = url;
        this.region = region;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public int getWidth() {
        if (this.region != null) {
            return Math.round(this.region.getWidth());
        }
        return Math.round(Browser.getImageWidth(this.id));
    }

    @Override
    public int getHeight() {
        if (this.region != null) {
            return Math.round(this.region.getHeight());
        }
        return Math.round(Browser.getImageHeight(this.id));
    }

    public Rect getRegion() {
        return this.region;
    }

    @Override
    public Image getRegion(Rect region) {
        return new TeaImage(this.id, this.url, region);
    }

    @Override
    public ColorRGB getColor(int x, int y) {
        float[] rgba = Browser.getImageData(this.id, x, y);
        int r = Math.round(rgba[0]);
        int g = Math.round(rgba[1]);
        int b = Math.round(rgba[2]);
        if (r < 0) {
            return null;
        }
        return new ColorRGB(r, g, b);
    }

    @Override
    public int getAlpha(int x, int y) {
        float[] rgba = Browser.getImageData(this.id, x, y);
        return Math.round(rgba[3] / 2.55f);
    }

    public boolean equals(Object o) {
        if (o instanceof TeaImage) {
            TeaImage other = (TeaImage)o;
            return this.id.equals(other.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.url;
    }
}

