/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.renderer.ApplicationData;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.InternetAccess;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Renderable;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.Updatable;
import nl.colorize.multimedialib.renderer.teavm.AnimationFrameCallback;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphicsContext;
import nl.colorize.multimedialib.renderer.teavm.TeaInputDevice;
import nl.colorize.multimedialib.renderer.teavm.TeaInternetAccess;
import nl.colorize.multimedialib.renderer.teavm.TeaLocalStorage;
import nl.colorize.multimedialib.renderer.teavm.TeaMediaLoader;
import nl.colorize.util.PlatformFamily;

public class TeaRenderer
implements Renderer,
AnimationFrameCallback {
    private Canvas canvas;
    private TeaGraphicsContext graphics;
    private TeaInputDevice inputDevice;
    private TeaMediaLoader mediaLoader;
    private boolean isMediaRequired;
    private List<Updatable> updateCallbacks;
    private List<Renderable> renderCallbacks;

    public TeaRenderer(Canvas canvas) {
        this.canvas = canvas;
        this.graphics = new TeaGraphicsContext(canvas);
        this.inputDevice = new TeaInputDevice(canvas, this.getPlatform());
        this.mediaLoader = new TeaMediaLoader();
        this.isMediaRequired = false;
        this.updateCallbacks = new ArrayList<Updatable>();
        this.renderCallbacks = new ArrayList<Renderable>();
        Browser.startAnimationLoop(this);
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas;
    }

    @Override
    public InputDevice getInputDevice() {
        return this.inputDevice;
    }

    @Override
    public MediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    @Override
    public ApplicationData getApplicationData(String appName) {
        return new TeaLocalStorage();
    }

    @Override
    public InternetAccess getInternetAccess() {
        return new TeaInternetAccess();
    }

    @Override
    public void addUpdateCallback(Updatable callback) {
        this.updateCallbacks.add(callback);
    }

    @Override
    public void addRenderCallback(Renderable callback) {
        this.renderCallbacks.add(callback);
    }

    @Override
    public void onFrame(float deltaTime, boolean update, boolean render) {
        this.updateCanvas();
        this.inputDevice.update(deltaTime);
        if (this.isReady()) {
            if (update) {
                for (Updatable updateCallback : this.updateCallbacks) {
                    updateCallback.update(deltaTime);
                }
            }
            if (render) {
                for (Renderable renderCallback : this.renderCallbacks) {
                    renderCallback.render(this.graphics);
                }
            }
        }
    }

    private boolean isReady() {
        int canvasWidth = Math.round(Browser.getCanvasWidth());
        int canvasHeight = Math.round(Browser.getCanvasHeight());
        if (canvasWidth > 0 || canvasHeight > 0) {
            return !this.isMediaRequired || this.mediaLoader.isImageLoadingComplete();
        }
        return false;
    }

    private void updateCanvas() {
        int canvasWidth = Math.round(Browser.getCanvasWidth());
        int canvasHeight = Math.round(Browser.getCanvasHeight());
        if (canvasWidth > 0 && canvasHeight > 0) {
            this.canvas.resizeScreen(canvasWidth, canvasHeight);
        }
    }

    public void requireMediaLoadingComplete() {
        this.isMediaRequired = true;
    }

    @Override
    public PlatformFamily getPlatform() {
        String userAgent = Browser.getUserAgent().toLowerCase();
        if (userAgent.contains("iphone") || userAgent.contains("ipad")) {
            return PlatformFamily.IOS;
        }
        if (userAgent.contains("android")) {
            return PlatformFamily.ANDROID;
        }
        if (userAgent.contains("mac")) {
            return PlatformFamily.MAC;
        }
        return PlatformFamily.WINDOWS;
    }

    @Override
    public String takeScreenshot() {
        return Browser.takeScreenshot();
    }
}

