/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.RotatingBuffer;
import nl.colorize.multimedialib.renderer.ApplicationData;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GraphicsContext;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.InternetAccess;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Renderable;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.Updatable;
import nl.colorize.multimedialib.scene.Effect;
import nl.colorize.multimedialib.scene.MediaCache;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.util.Stopwatch;
import nl.colorize.util.animation.Interpolation;
import nl.colorize.util.animation.Timeline;

public class Application
implements Updatable,
Renderable {
    private Renderer renderer;
    private MediaCache mediaCache;
    private Scene activeScene;
    private Scene requestedScene;
    private boolean orientationLock;
    private Effect orientationLockAnim;
    private Stopwatch upsTimer;
    private Stopwatch fpsTimer;
    private RotatingBuffer upsBuffer;
    private RotatingBuffer fpsBuffer;
    private RotatingBuffer frameTimeBuffer;
    private static final int FPS_MEASUREMENT_BUFFER_SIZE = 100;
    private static final FilePointer ORIENTATION_LOCK_IMAGE = new FilePointer("orientation-lock.png");

    public Application(Renderer renderer) {
        this.renderer = renderer;
        this.mediaCache = new MediaCache(renderer.getMediaLoader());
        this.orientationLock = false;
        this.orientationLockAnim = this.initOrientationLockAnim();
        this.upsTimer = new Stopwatch();
        this.fpsTimer = new Stopwatch();
        this.upsBuffer = new RotatingBuffer(100);
        this.fpsBuffer = new RotatingBuffer(100);
        this.frameTimeBuffer = new RotatingBuffer(100);
        renderer.addUpdateCallback(this);
        renderer.addRenderCallback(this);
    }

    private Effect initOrientationLockAnim() {
        Image orientationLockImage = this.mediaCache.loadImage(ORIENTATION_LOCK_IMAGE);
        Timeline timeline = new Timeline(Interpolation.EASE, true);
        timeline.addKeyFrame(0.0f, 100.0f);
        timeline.addKeyFrame(1.0f, 110.0f);
        timeline.addKeyFrame(2.0f, 100.0f);
        Effect effect = Effect.forImage(orientationLockImage, timeline);
        effect.modify(value -> effect.getTransform().setScale(Math.round(value.floatValue())));
        return effect;
    }

    public void changeScene(Scene requestedScene) {
        Preconditions.checkState((this.requestedScene == null ? 1 : 0) != 0, (Object)("Another scene has already been requested: " + requestedScene));
        this.requestedScene = requestedScene;
    }

    public Scene getActiveScene() {
        return this.activeScene;
    }

    public void lockScreenOrientation() {
        this.orientationLock = true;
    }

    @Override
    public void update(float deltaTime) {
        long upsValue = this.upsTimer.tick();
        this.upsBuffer.add(upsValue);
        if (this.requestedScene != null) {
            if (this.activeScene != null) {
                this.activeScene.end();
            }
            this.activeScene = this.requestedScene;
            this.requestedScene = null;
            this.activeScene.start();
        }
        Stopwatch frameTimer = new Stopwatch();
        frameTimer.tick();
        if (this.activeScene != null && this.isScreenOrientationSupported()) {
            this.activeScene.update(deltaTime);
        } else {
            this.orientationLockAnim.update(deltaTime);
        }
        long actualFrameTime = frameTimer.tick();
        this.frameTimeBuffer.add(actualFrameTime);
    }

    private boolean isScreenOrientationSupported() {
        if (!this.orientationLock) {
            return true;
        }
        Canvas canvas = this.renderer.getCanvas();
        return canvas.getWidth() > 0 && canvas.getWidth() > canvas.getHeight();
    }

    @Override
    public void render(GraphicsContext graphics) {
        if (this.activeScene != null) {
            long fpsValue = this.fpsTimer.tick();
            this.fpsBuffer.add(fpsValue);
            if (this.isScreenOrientationSupported()) {
                this.activeScene.render(graphics);
            } else {
                this.drawOrientationLock(graphics);
            }
        }
    }

    private void drawOrientationLock(GraphicsContext graphics) {
        Canvas canvas = this.getCanvas();
        this.orientationLockAnim.setPosition((float)canvas.getWidth() / 2.0f, (float)canvas.getHeight() / 2.0f);
        this.orientationLockAnim.render(graphics);
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public Canvas getCanvas() {
        return this.renderer.getCanvas();
    }

    public InputDevice getInputDevice() {
        return this.renderer.getInputDevice();
    }

    public MediaLoader getMediaLoader() {
        return this.mediaCache;
    }

    public ApplicationData getApplicationData(String appName) {
        return this.renderer.getApplicationData(appName);
    }

    public InternetAccess getInternetAccess() {
        return this.renderer.getInternetAccess();
    }

    public float getAverageUPS() {
        return 1000.0f / this.upsBuffer.getAverageValue();
    }

    public float getAverageFPS() {
        return 1000.0f / this.fpsBuffer.getAverageValue();
    }

    public float getAverageFrameTime() {
        return this.frameTimeBuffer.getAverageValue();
    }
}

