/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.renderer.Audio;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.MediaLoader;

public class MediaCache
implements MediaLoader {
    private MediaLoader delegate;
    private Map<FilePointer, Object> cache;

    protected MediaCache(MediaLoader delegate) {
        Preconditions.checkArgument((!(delegate instanceof MediaCache) ? 1 : 0) != 0, (Object)"Cannot use nested instances of MediaCache");
        this.delegate = delegate;
        this.cache = new HashMap<FilePointer, Object>();
    }

    private <T> T get(FilePointer file, Supplier<T> mediaSupplier) {
        Object result = this.cache.get(file);
        if (result == null) {
            result = mediaSupplier.get();
            this.cache.put(file, result);
        }
        return (T)result;
    }

    @Override
    public Image loadImage(FilePointer file) {
        return this.get(file, () -> this.delegate.loadImage(file));
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        return this.get(file, () -> this.delegate.loadAudio(file));
    }

    @Override
    public TTFont loadFont(String fontFamily, FilePointer file) {
        return this.get(file, () -> this.delegate.loadFont(fontFamily, file));
    }

    @Override
    public String loadText(FilePointer file) {
        return this.get(file, () -> this.delegate.loadText(file));
    }

    @Override
    public boolean containsResourceFile(FilePointer file) {
        return this.delegate.containsResourceFile(file);
    }

    public void invalidate() {
        this.cache.clear();
    }
}

