/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.util.LogHelper;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public abstract class CommandLineTool {
    private PrintStream usageStream = System.err;
    private static final Logger LOGGER = LogHelper.getLogger(CommandLineTool.class);

    public final void start(String[] args) {
        CmdLineParser cmdParser = new CmdLineParser((Object)this);
        cmdParser.getProperties().withUsageWidth(80);
        try {
            cmdParser.parseArgument(args);
            this.run();
        }
        catch (CmdLineException e) {
            this.printUsage(cmdParser);
            LOGGER.info(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while running tool", e);
        }
    }

    private void printUsage(CmdLineParser cmdParser) {
        this.usageStream.println(this.getClass().getSimpleName());
        this.usageStream.println();
        this.usageStream.println("Arguments:");
        cmdParser.printUsage((OutputStream)this.usageStream);
        this.usageStream.println();
    }

    public abstract void run();
}

