/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.tool.CommandLineTool;
import nl.colorize.util.FileUtils;
import nl.colorize.util.LoadUtils;
import nl.colorize.util.LogHelper;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.xml.XMLHelper;
import org.jdom2.Element;
import org.kohsuke.args4j.Option;
import org.teavm.diagnostics.Problem;
import org.teavm.tooling.ConsoleTeaVMToolLog;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.tooling.TeaVMTool;
import org.teavm.tooling.TeaVMToolException;
import org.teavm.tooling.TeaVMToolLog;

public class TeaVMTranspiler
extends CommandLineTool {
    @Option(name="-project", required=true, usage="Project name for the application")
    public String projectName;
    @Option(name="-resources", required=true, usage="Location of the application's resource files")
    public File resourceDir;
    @Option(name="-out", required=true, usage="Output directory for the generated filess")
    public File outputDir;
    @Option(name="-main", required=true, usage="Main class that acts as application entry point")
    public String mainClassName;
    @Option(name="-incremental", usage="Enable to preserveexisting resource files and not overwrite them")
    public boolean incremental = false;
    private static final List<ResourceFile> WEB_RESOURCE_FILES = ImmutableList.of((Object)new ResourceFile("web/index.html"), (Object)new ResourceFile("web/multimedialib.css"), (Object)new ResourceFile("web/multimedialib.js"), (Object)new ResourceFile("web/canvas-renderer.js"), (Object)new ResourceFile("web/webgl-renderer.js"), (Object)new ResourceFile("web/favicon.png"), (Object)new ResourceFile("web/apple-icon.png"), (Object)new ResourceFile("web/orientation-lock.png"), (Object)new ResourceFile("web/loading.gif"), (Object)new ResourceFile("web/OpenSans-Regular.ttf"));
    private static final List<String> TEXT_RESOURCE_FILE_TYPES = ImmutableList.of((Object)".txt", (Object)".md", (Object)".json", (Object)".yml", (Object)".yaml", (Object)".properties", (Object)".fnt", (Object)"-manifest");
    private static final List<String> KNOWN_MISSING_CLASSES = Collections.emptyList();
    private static final Logger LOGGER = LogHelper.getLogger(TeaVMTranspiler.class);

    public static void main(String[] args) {
        TeaVMTranspiler tool = new TeaVMTranspiler();
        tool.start(args);
    }

    @Override
    public void run() {
        Preconditions.checkArgument((boolean)this.resourceDir.exists(), (Object)"Resource directory not found");
        this.outputDir.mkdir();
        try {
            this.copyResources();
            this.transpile();
            LOGGER.info("Results saved to " + this.outputDir.getAbsolutePath());
        }
        catch (TeaVMToolException e) {
            LOGGER.log(Level.SEVERE, "Transpiling failed", e);
        }
    }

    private void transpile() throws TeaVMToolException {
        LOGGER.info("Transpiling " + this.projectName + " to JavaScript");
        TeaVMTool transpiler = new TeaVMTool();
        transpiler.setClassLoader(this.getClass().getClassLoader());
        transpiler.setDebugInformationGenerated(true);
        transpiler.setIncremental(false);
        transpiler.setLog((TeaVMToolLog)new ConsoleTeaVMToolLog(true));
        transpiler.setMainClass(this.mainClassName);
        transpiler.setMinifying(false);
        transpiler.setSourceMapsFileGenerated(true);
        transpiler.setTargetDirectory(this.outputDir);
        transpiler.setTargetType(TeaVMTargetType.JAVASCRIPT);
        transpiler.generate();
        for (Problem problem : transpiler.getProblemProvider().getProblems()) {
            if (!this.shouldReport(problem)) continue;
            LOGGER.log(Level.WARNING, "Error while transpiling: " + this.format(problem));
        }
    }

    private boolean shouldReport(Problem problem) {
        String params = Arrays.toString(problem.getParams());
        return KNOWN_MISSING_CLASSES.stream().noneMatch(entry -> params.equals(entry));
    }

    private String format(Problem problem) {
        String text = problem.getText() + " " + Arrays.toString(problem.getParams());
        if (problem.getLocation() != null) {
            text = text + " (" + problem.getLocation().getSourceLocation() + ")";
        }
        return text;
    }

    private void copyResources() {
        List<ResourceFile> resourceFiles = this.gatherResourceFiles();
        resourceFiles.add(this.generateManifest(resourceFiles));
        ArrayList<ResourceFile> textResourceFiles = new ArrayList<ResourceFile>();
        for (ResourceFile file : resourceFiles) {
            if (this.isTextResourceFile(file)) {
                textResourceFiles.add(file);
                continue;
            }
            if (!this.shouldWrite(file)) continue;
            LOGGER.info("Copying resource file " + file.getPath());
            this.copyBinaryResourceFile(file);
        }
        for (ResourceFile file : WEB_RESOURCE_FILES) {
            if (file.getName().endsWith(".html")) {
                LOGGER.info("Generating HTML file " + file.getPath());
                this.rewriteHTML(file, textResourceFiles);
                continue;
            }
            if (!this.shouldWrite(file)) continue;
            LOGGER.info("Generating file " + file.getPath());
            this.copyBinaryResourceFile(file);
        }
    }

    private boolean isTextResourceFile(ResourceFile file) {
        return TEXT_RESOURCE_FILE_TYPES.stream().anyMatch(type -> file.getName().toLowerCase().endsWith((String)type));
    }

    private boolean shouldWrite(ResourceFile file) {
        File outputFile = this.getOutputFile(file);
        return !this.incremental || !outputFile.exists();
    }

    private void rewriteHTML(ResourceFile file, List<ResourceFile> textResourceFiles) {
        File outputFile = this.getOutputFile(file);
        try (PrintWriter writer = new PrintWriter(outputFile, Charsets.UTF_8.displayName());){
            for (String line : file.readLines(Charsets.UTF_8)) {
                if ((line = line.replace("@@@PROJECT", this.projectName)).trim().equals("@@@RESOURCES")) {
                    line = this.generateTextResourceFilesHTML(textResourceFiles);
                }
                writer.println(line);
            }
        }
        catch (IOException e) {
            throw new MediaException("Cannot write to file: " + outputFile.getAbsolutePath(), e);
        }
    }

    private String generateTextResourceFilesHTML(List<ResourceFile> files) throws IOException {
        StringBuilder buffer = new StringBuilder();
        for (ResourceFile file : files) {
            Element element = new Element("div");
            element.setAttribute("id", this.normalizeFileName(file).replace(".", "_"));
            element.setText(file.read(Charsets.UTF_8));
            String xml = XMLHelper.toString((Element)element);
            buffer.append(xml);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private void copyBinaryResourceFile(ResourceFile file) {
        try (InputStream stream = file.openStream();){
            byte[] contents = LoadUtils.readToByteArray((InputStream)stream);
            FileUtils.write((byte[])contents, (File)this.getOutputFile(file));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Cannot copy file " + file, e);
        }
    }

    private List<ResourceFile> gatherResourceFiles() {
        try {
            return Files.walk(this.resourceDir.toPath(), new FileVisitOption[0]).map(path -> path.toFile()).filter(file -> !file.isDirectory() && !file.getName().startsWith(".")).map(file -> new ResourceFile(file)).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new MediaException("Cannot read resource files directory: " + this.resourceDir, e);
        }
    }

    private ResourceFile generateManifest(List<ResourceFile> resourceFiles) {
        try {
            File tempDir = Files.createTempDirectory("resource-file-manifest", new FileAttribute[0]).toFile();
            File manifestFile = new File(tempDir, "resource-file-manifest");
            List entries = resourceFiles.stream().map(file -> this.normalizeFileName((ResourceFile)file)).sorted().collect(Collectors.toList());
            Files.write(manifestFile.toPath(), entries, Charsets.UTF_8, new OpenOption[0]);
            return new ResourceFile(manifestFile);
        }
        catch (IOException e) {
            throw new MediaException("Cannot generate resource file manifest", e);
        }
    }

    private File getOutputFile(ResourceFile file) {
        return new File(this.outputDir, this.normalizeFileName(file));
    }

    private String normalizeFileName(ResourceFile file) {
        return file.getName().replace("/", "_");
    }
}

