//-----------------------------------------------------------------------------
// Colorize MultimediaLib
// Copyright 2009-2020 Colorize
// Apache license (http://www.apache.org/licenses/LICENSE-2.0)
//-----------------------------------------------------------------------------

package nl.colorize.multimedialib.graphics;

/**
 * Shared interface between TrueType fonts and bitmap fonts, so that applications
 * can easily switch between the two.
 */
public interface TextFont {

    public String getFamily();

    public int getSize();

    /**
     * Returns a version of this font that uses the same font family and color,
     * but has a different size.
     */
    public TextFont derive(int newSize);

    /**
     * Returns a version of this font which uses the same font family and size,
     * but has a different color.
     */
    public TextFont derive(ColorRGB newColor);

    /**
     * Returns a bold version of this font. All all properties will be identical
     * to the current font.
     */
    public TextFont deriveBold();
}
