//-----------------------------------------------------------------------------
// Colorize MultimediaLib
// Copyright 2009-2020 Colorize
// Apache license (http://www.apache.org/licenses/LICENSE-2.0)
//-----------------------------------------------------------------------------

package nl.colorize.multimedialib.renderer;

import java.util.List;

/**
 * Interface for sending and receiving messages through a web socket connection.
 * Note that web sockets might not be supported on all platforms.
 */
public interface WebSocketConnection {

    public void send(String message);

    /**
     * Returns the list of all messages that were received since the last time
     * this method was called, then clears the list. This method can be called
     * during frame updates to process received messages as part of the
     * animation loop.
     */
    public List<String> flushReceivedMessages();

    public void close();
}
