//-----------------------------------------------------------------------------
// Colorize MultimediaLib
// Copyright 2009-2020 Colorize
// Apache license (http://www.apache.org/licenses/LICENSE-2.0)
//-----------------------------------------------------------------------------

package nl.colorize.multimedialib.scene;

import nl.colorize.multimedialib.renderer.Renderable;
import nl.colorize.multimedialib.renderer.Updatable;

/**
 * Represents a discrete part or phase of an application, that is active for
 * some period of time. Simple applications might consist of a single scene,
 * complex applications can have dozens. Scenes can contain logic, rendering,
 * though they will typically do both.
 * <p>
 * Scenes will receive updates at various points throughout their life cycle:
 * when the scene is started (which can occur multiple times depending on the
 * application flow), and then frame updates and rendering when the scene is
 * active.
 */
public interface Scene extends Updatable, Renderable {

    /**
     * Initiallization logic that is performed every time the scene is started.
     * Implementing this method is optional, the default implementation does
     * nothing.
     */
    default void start() {
    }

    /**
     * Clean-up logic that is performed every time the scene ends. Implementing
     * this method is optional, the default implementation does nothing.
     */
    default void end() {
    }
}
