//-----------------------------------------------------------------------------
// Colorize MultimediaLib
// Copyright 2009-2020 Colorize
// Apache license (http://www.apache.org/licenses/LICENSE-2.0)
//-----------------------------------------------------------------------------

package nl.colorize.multimedialib.scene.ui;

import nl.colorize.multimedialib.scene.Scene;

/**
 * Base class for all subsystems that emulate user interface widgets
 * (buttons, select boxes, text fields, etc.). This does not actually use the
 * platform's native user interface, but implements graphics and interaction
 * entirely in MultimediaLib so that the widgets works across all platforms.
 */
public abstract class Widget implements Scene {

    private Location location;
    private WidgetStyle style;

    public Widget(WidgetStyle style) {
        this.location = Location.fixed(0f, 0f);
        this.style = style;
    }

    /**
     * Widgets do not have initialization logic by default, but this can be
     * added by overriding this method.
     */
    @Override
    public void start() {
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return location;
    }

    protected float getX() {
        return location.getX();
    }

    protected float getY() {
        return location.getY();
    }

    public WidgetStyle getStyle() {
        return style;
    }
}
