/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import java.util.Objects;

public class Point {
    private float x;
    private float y;
    public static final float EPSILON = 0.001f;

    public Point(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getX() {
        return this.x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getY() {
        return this.y;
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(Point p) {
        this.set(p.getX(), p.getY());
    }

    public void move(float deltaX, float deltaY) {
        this.x += deltaX;
        this.y += deltaY;
    }

    public void add(float deltaX, float deltaY) {
        this.move(deltaX, deltaY);
    }

    public void add(float delta) {
        this.add(delta, delta);
    }

    public void add(Point p) {
        this.add(p.getX(), p.getY());
    }

    public void multiply(float deltaX, float deltaY) {
        this.x *= deltaX;
        this.y *= deltaY;
    }

    public void multiply(float delta) {
        this.multiply(delta, delta);
    }

    public float calculateDistance(Point other) {
        if (this.equals(other)) {
            return 0.0f;
        }
        float deltaX = Math.abs(other.x - this.x);
        float deltaY = Math.abs(other.y - this.y);
        return (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public float calculateAngle(Point other) {
        if (this.equals(other)) {
            return 0.0f;
        }
        double radians = Math.atan2(other.y - this.y, other.x - this.x);
        float angle = (float)Math.toDegrees(radians);
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public Point copy() {
        return new Point(this.x, this.y);
    }

    public boolean equals(Object o) {
        if (o instanceof Point) {
            Point other = (Point)o;
            return Math.abs(this.x - other.x) < 0.001f && Math.abs(this.y - other.y) < 0.001f;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y));
    }

    public String toString() {
        return "(" + Math.round(this.x) + ", " + Math.round(this.y) + ")";
    }
}

