/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import nl.colorize.multimedialib.math.Point;
import nl.colorize.multimedialib.math.Shape;
import nl.colorize.multimedialib.math.Vector;

public class Polygon
implements Shape {
    private float[] points;

    public Polygon(float ... points) {
        this.setPoints(points);
    }

    public void setPoints(float ... points) {
        Preconditions.checkArgument((points.length >= 6 ? 1 : 0) != 0, (Object)"Convex polygon must have at least 3 points");
        Preconditions.checkArgument((points.length % 2 != 1 ? 1 : 0) != 0, (Object)("Points array must have equal number of X and Y coordinates: " + Arrays.toString(points)));
        this.points = points;
    }

    public float[] getPoints() {
        return this.points;
    }

    public int getNumPoints() {
        return this.points.length / 2;
    }

    public float getPointX(int n) {
        return this.points[2 * n];
    }

    public float getPointY(int n) {
        return this.points[2 * n + 1];
    }

    public void move(float dx, float dy) {
        for (int i = 0; i < this.points.length; i += 2) {
            int n = i;
            this.points[n] = this.points[n] + dx;
            int n2 = i + 1;
            this.points[n2] = this.points[n2] + dy;
        }
    }

    @Override
    public boolean contains(Point p) {
        return this.isPointInPolygon(p.getX(), p.getY()) || this.isPointOnLineSegment(p.getX(), p.getY());
    }

    private boolean isPointInPolygon(float px, float py) {
        boolean oddNodes = false;
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = this.points[this.points.length - 2];
        float y2 = this.points[this.points.length - 1];
        for (int i = 0; i < this.points.length; i += 2) {
            x1 = this.points[i];
            y1 = this.points[i + 1];
            if ((y1 < py && y2 >= py || y1 >= py && y2 < py) && (py - y1) / (y2 - y1) * (x2 - x1) < px - x1) {
                oddNodes = !oddNodes;
            }
            x2 = x1;
            y2 = y1;
        }
        return oddNodes;
    }

    private boolean isPointOnLineSegment(float px, float py) {
        for (int i = 0; i < this.points.length - 2; i += 2) {
            if (!this.isPointOnLineSegment(this.points[i], this.points[i + 1], this.points[i + 2], this.points[i + 3], px, py)) continue;
            return true;
        }
        return this.isPointOnLineSegment(this.points[this.points.length - 2], this.points[this.points.length - 1], this.points[0], this.points[1], px, py);
    }

    private boolean isPointOnLineSegment(float x0, float y0, float x1, float y1, float px, float py) {
        float crossproduct = (py - y0) * (x1 - x0) - (px - x0) * (y1 - y0);
        if (crossproduct != 0.0f) {
            return false;
        }
        float dotproduct = (px - x0) * (x1 - x0) + (py - y0) * (x1 - y0);
        if (dotproduct < 0.0f) {
            return false;
        }
        float squaredLength = (x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0);
        return dotproduct <= squaredLength;
    }

    public boolean intersects(Polygon p) {
        float[] pPoints = p.getPoints();
        for (int i = 0; i < this.points.length; i += 2) {
            int iNext = i + 2;
            if (iNext >= this.points.length) {
                iNext = 0;
            }
            for (int j = 0; j < pPoints.length; j += 2) {
                int jNext = j + 2;
                if (jNext >= pPoints.length) {
                    jNext = 0;
                }
                double unknownA = ((this.points[iNext] - this.points[i]) * (pPoints[j + 1] - this.points[i + 1]) - (this.points[iNext + 1] - this.points[i + 1]) * (pPoints[j] - this.points[i])) / ((this.points[iNext + 1] - this.points[i + 1]) * (pPoints[jNext] - pPoints[j]) - (this.points[iNext] - this.points[i]) * (pPoints[jNext + 1] - pPoints[j + 1]));
                double unknownB = ((pPoints[jNext] - pPoints[j]) * (pPoints[j + 1] - this.points[i + 1]) - (pPoints[jNext + 1] - pPoints[j + 1]) * (pPoints[j] - this.points[i])) / ((this.points[iNext + 1] - this.points[i + 1]) * (pPoints[jNext] - pPoints[j]) - (this.points[iNext] - this.points[i]) * (pPoints[jNext + 1] - pPoints[j + 1]));
                if (!(unknownA >= 0.0) || !(unknownA <= 1.0) || !(unknownB >= 0.0) || !(unknownB <= 1.0)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof Polygon) {
            Polygon other = (Polygon)o;
            if (this.points.length != other.points.length) {
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                if (!(Math.abs(this.points[i] - other.points[i]) > 0.001f)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.points);
    }

    public String toString() {
        return Arrays.toString(this.points);
    }

    public static Polygon createCircle(Point origin, float radius, int numPoints) {
        Preconditions.checkArgument((numPoints >= 4 ? 1 : 0) != 0, (Object)("Circle polygon must consist of at least 4 points, got " + numPoints));
        Preconditions.checkArgument((radius > 0.001f ? 1 : 0) != 0, (Object)("Invalid radius: " + radius));
        float[] points = new float[numPoints * 2];
        Vector vector = new Vector(0.0f, radius);
        for (int i = 0; i < numPoints; ++i) {
            vector.setDirection((float)i * (360.0f / (float)numPoints));
            points[i * 2] = origin.getX() + vector.getX();
            points[i * 2 + 1] = origin.getY() + vector.getY();
        }
        return new Polygon(points);
    }

    public static Polygon createCone(Point origin, float startAngle, float arc, float length) {
        Preconditions.checkArgument((arc > 0.0f && arc <= 180.0f ? 1 : 0) != 0, (Object)("Invalid arc: " + arc));
        Preconditions.checkArgument((length > 0.0f ? 1 : 0) != 0, (Object)("Invalid length: " + length));
        Vector left = new Vector(startAngle % 360.0f - arc / 2.0f, length);
        Vector right = new Vector(startAngle % 360.0f + arc / 2.0f, length);
        return new Polygon(origin.getX(), origin.getY(), origin.getX() + left.getX(), origin.getY() + left.getY(), origin.getX() + right.getX(), origin.getY() + right.getY());
    }
}

