/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import java.util.Objects;
import nl.colorize.multimedialib.math.Point;
import nl.colorize.multimedialib.math.Shape;

public class Rect
implements Shape {
    private float x;
    private float y;
    private float width;
    private float height;

    public Rect(float x, float y, float width, float height) {
        this.set(x, y, width, height);
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        Preconditions.checkArgument((width >= 0.0f ? 1 : 0) != 0, (Object)("Invalid width: " + width));
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        Preconditions.checkArgument((height >= 0.0f ? 1 : 0) != 0, (Object)("Invalid height: " + height));
        this.height = height;
    }

    public float getCenterX() {
        return this.x + this.width / 2.0f;
    }

    public float getCenterY() {
        return this.y + this.height / 2.0f;
    }

    public float getEndX() {
        return this.x + this.width;
    }

    public float getEndY() {
        return this.y + this.height;
    }

    public void set(float x, float y, float width, float height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public void set(Rect r) {
        this.set(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean contains(Point p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(float px, float py) {
        return px >= this.x && px <= this.x + this.width && py >= this.y && py <= this.y + this.height;
    }

    public boolean contains(Rect r) {
        return r.x >= this.x && r.x + r.width <= this.x + this.width && r.y >= this.y && r.y + r.height <= this.y + this.height;
    }

    public boolean intersects(Rect r) {
        return !(r.x + r.width < this.x || r.x > this.x + this.width || r.y + r.height < this.y || r.y > this.y + this.height);
    }

    public Rect copy() {
        return new Rect(this.x, this.y, this.width, this.height);
    }

    public boolean equals(Object o) {
        if (o instanceof Rect) {
            Rect other = (Rect)o;
            return Math.abs(this.x - other.x) < 0.001f && Math.abs(this.y - other.y) < 0.001f && Math.abs(this.width - other.width) < 0.001f && Math.abs(this.height - other.height) < 0.001f;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.width), Float.valueOf(this.height));
    }

    public String toString() {
        return Math.round(this.x) + ", " + Math.round(this.y) + ", " + Math.round(this.width) + ", " + Math.round(this.height);
    }

    public static Rect around(float x, float y, float width, float height) {
        return Rect.around(new Point(x, y), width, height);
    }

    public static Rect around(Point center, float width, float height) {
        return new Rect(center.getX() - width / 2.0f, center.getY() - height / 2.0f, width, height);
    }
}

