/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import java.util.Date;
import nl.colorize.multimedialib.graphics.ColorRGB;

public interface ApplicationData {
    public void set(String var1, String var2);

    public String get(String var1, String var2);

    default public void remove(String key) {
        this.set(key, (String)null);
    }

    public void clear();

    default public void set(String key, int value) {
        this.set(key, String.valueOf(value));
    }

    default public int get(String key, int defaultValue) {
        return Integer.parseInt(this.get(key, String.valueOf(defaultValue)));
    }

    default public void set(String key, float value) {
        this.set(key, String.valueOf(value));
    }

    default public float get(String key, float defaultValue) {
        return Float.parseFloat(this.get(key, String.valueOf(defaultValue)));
    }

    default public void set(String key, boolean value) {
        this.set(key, String.valueOf(value));
    }

    default public boolean get(String key, boolean defaultValue) {
        return this.get(key, String.valueOf(defaultValue)).equals("true");
    }

    default public void set(String key, Date date) {
        this.set(key, String.valueOf(date.getTime()));
    }

    default public Date get(String key, Date defaultValue) {
        long timestamp = Long.parseLong(this.get(key, String.valueOf(defaultValue.getTime())));
        return new Date(timestamp);
    }

    default public void set(String key, ColorRGB color) {
        this.set(key, color.toHex());
    }

    default public ColorRGB get(String key, ColorRGB defaultValue) {
        String hex = this.get(key, defaultValue.toHex());
        return ColorRGB.parseHex(hex);
    }
}

