/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import java.awt.BufferCapabilities;
import java.awt.Graphics;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.java2d.Java2DRenderer;
import nl.colorize.multimedialib.renderer.java2d.WindowOptions;
import nl.colorize.util.swing.Utils2D;

public class HeadlessRenderer
extends Java2DRenderer {
    private HeadlessWindowBuffer buffer;

    public HeadlessRenderer(Canvas canvas, int framerate, WindowOptions windowOptions) {
        super(canvas, framerate, windowOptions);
    }

    @Override
    protected JFrame initializeWindow(WindowOptions windowOptions) {
        return null;
    }

    @Override
    protected void prepareCanvas() {
    }

    @Override
    protected BufferStrategy prepareWindowBuffer() {
        Canvas canvas = this.getCanvas();
        if (this.isBufferDirty(canvas)) {
            this.buffer = new HeadlessWindowBuffer();
            this.buffer.image = new BufferedImage(canvas.getWidth(), canvas.getHeight(), 2);
        }
        return this.buffer;
    }

    private boolean isBufferDirty(Canvas canvas) {
        if (this.buffer == null || this.buffer.image == null) {
            return true;
        }
        return this.buffer.image.getWidth() != canvas.getWidth() || this.buffer.image.getHeight() != canvas.getHeight();
    }

    @Override
    protected void blitGraphicsContext(BufferStrategy windowBuffer) {
    }

    public BufferedImage getImage() {
        return this.buffer.image;
    }

    public void saveScreenshot(File dest) {
        try {
            Utils2D.savePNG((BufferedImage)this.buffer.image, (File)dest);
        }
        catch (IOException e) {
            throw new MediaException("Cannot save image", e);
        }
    }

    private static class HeadlessWindowBuffer
    extends BufferStrategy {
        private BufferedImage image;

        private HeadlessWindowBuffer() {
        }

        @Override
        public BufferCapabilities getCapabilities() {
            return null;
        }

        @Override
        public Graphics getDrawGraphics() {
            return Utils2D.createGraphics((BufferedImage)this.image, (boolean)true, (boolean)true);
        }

        @Override
        public boolean contentsLost() {
            return false;
        }

        @Override
        public boolean contentsRestored() {
            return false;
        }

        @Override
        public void show() {
        }
    }
}

