/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsContext;
import nl.colorize.multimedialib.scene.Application;
import nl.colorize.multimedialib.scene.EffectManager;
import nl.colorize.multimedialib.scene.Scene;

public abstract class ComplexScene
implements Scene {
    private Application app;
    private List<Scene> subSystems = Collections.emptyList();
    private EffectManager effectManager = new EffectManager();
    private ColorRGB backgroundColor;

    public ComplexScene(Application app) {
    }

    @Override
    public final void start() {
        this.initScene();
        this.subSystems = new ImmutableList.Builder().addAll(this.initSubSystems()).add((Object)this.effectManager).build();
        for (Scene subSystem : this.subSystems) {
            subSystem.start();
        }
    }

    protected abstract void initScene();

    protected abstract List<Scene> initSubSystems();

    @Override
    public void update(float deltaTime) {
        for (Scene subSystem : this.subSystems) {
            subSystem.update(deltaTime);
        }
    }

    @Override
    public void render(GraphicsContext graphics) {
        if (this.backgroundColor != null) {
            graphics.drawBackground(this.backgroundColor);
        }
        for (Scene subSystem : this.subSystems) {
            if (!this.shouldRender(subSystem)) continue;
            subSystem.render(graphics);
        }
    }

    protected boolean shouldRender(Scene subSystem) {
        return true;
    }

    protected Application getApp() {
        return this.app;
    }

    protected Canvas getCanvas() {
        return this.app.getCanvas();
    }

    public EffectManager getEffectManager() {
        return this.effectManager;
    }

    public void setBackgroundColor(ColorRGB backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public ColorRGB getBackgroundColor() {
        return this.backgroundColor;
    }
}

