/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene.ui;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import nl.colorize.multimedialib.graphics.Align;
import nl.colorize.multimedialib.math.Point;
import nl.colorize.multimedialib.renderer.GraphicsContext;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.scene.ui.Button;
import nl.colorize.multimedialib.scene.ui.Location;
import nl.colorize.multimedialib.scene.ui.SelectBox;
import nl.colorize.multimedialib.scene.ui.TextField;
import nl.colorize.multimedialib.scene.ui.TextLabel;
import nl.colorize.multimedialib.scene.ui.Widget;
import nl.colorize.multimedialib.scene.ui.WidgetStyle;

public class Form
extends Widget {
    private List<WidgetInfo> widgets;
    private InputDevice input;
    private WidgetStyle labelStyle;
    private float horizontalMargin;
    private float verticalMargin;
    private float labelOffset;

    public Form(Location location, WidgetStyle labelStyle, InputDevice input) {
        super(null);
        this.setLocation(location);
        this.widgets = new ArrayList<WidgetInfo>();
        this.labelStyle = labelStyle;
        this.input = input;
        this.horizontalMargin = 10.0f;
        this.verticalMargin = 20.0f;
        this.labelOffset = 0.0f;
    }

    private void addWidget(String label, Widget widget) {
        WidgetInfo widgetInfo = new WidgetInfo(widget);
        if (label != null && !label.isEmpty()) {
            widgetInfo.label = new TextLabel(this.labelStyle, label, Align.RIGHT);
        }
        this.widgets.add(widgetInfo);
        this.updateLayout();
    }

    public void add(TextLabel label) {
        this.addWidget("", label);
    }

    public Button add(String label, Button button, Runnable onClick) {
        this.addWidget(label, button);
        button.setClickHandler(this.input, onClick);
        return button;
    }

    public Button add(Button button, Runnable onClick) {
        return this.add("", button, onClick);
    }

    public SelectBox add(String label, SelectBox selectBox, Consumer<String> onChange) {
        this.addWidget(label, selectBox);
        selectBox.setClickHandler(this.input, onChange);
        return selectBox;
    }

    public SelectBox add(String label, SelectBox selectBox, Runnable onChange) {
        Consumer<String> onChangeWrapper = value -> onChange.run();
        return this.add(label, selectBox, onChangeWrapper);
    }

    public SelectBox add(String label, SelectBox selectBox) {
        return this.add(label, selectBox, (Consumer<String>)null);
    }

    public TextField add(String label, TextField textField, Consumer<String> onChange) {
        this.addWidget(label, textField);
        textField.setChangeHandler(this.input, onChange);
        return textField;
    }

    public TextField add(String label, TextField textField) {
        return this.add(label, textField, null);
    }

    public void addEmptyRow() {
        this.addWidget("", new TextLabel(this.labelStyle, ""));
    }

    public void setVisible(Widget widget, boolean visible) {
        for (WidgetInfo widgetInfo : this.widgets) {
            if (!widgetInfo.widget.equals(widget)) continue;
            widgetInfo.visible = visible;
            break;
        }
        this.updateLayout();
    }

    public void setMargin(float horizontalMargin, float verticalMargin) {
        this.horizontalMargin = horizontalMargin;
        this.verticalMargin = verticalMargin;
    }

    public void setLabelOffset(float labelOffset) {
        this.labelOffset = labelOffset;
    }

    @Override
    public void update(float deltaTime) {
        for (WidgetInfo widgetInfo : this.widgets) {
            widgetInfo.widget.update(deltaTime);
        }
        this.updateLayout();
    }

    private void updateLayout() {
        Point cursor = new Point(0.0f, 0.0f);
        Location parent = this.getLocation();
        for (WidgetInfo widgetInfo : this.widgets) {
            if (!widgetInfo.visible) continue;
            if (widgetInfo.label != null) {
                widgetInfo.label.setLocation(parent.relativeTo(-this.horizontalMargin / 2.0f, cursor.getY() + this.labelOffset));
            }
            widgetInfo.widget.setLocation(parent.relativeTo(this.getWidgetX(widgetInfo), cursor.getY()));
            cursor.setY(cursor.getY() + this.verticalMargin);
        }
    }

    private float getWidgetX(WidgetInfo widgetInfo) {
        WidgetStyle style = widgetInfo.widget.getStyle();
        if (style == null || style.getBackground() == null) {
            return this.horizontalMargin / 2.0f;
        }
        return this.horizontalMargin / 2.0f + (float)style.getBackground().getWidth() / 2.0f;
    }

    @Override
    public void render(GraphicsContext graphics) {
        for (WidgetInfo widgetInfo : this.widgets) {
            if (!widgetInfo.visible) continue;
            if (widgetInfo.label != null) {
                widgetInfo.label.render(graphics);
            }
            widgetInfo.widget.render(graphics);
        }
    }

    @Override
    public WidgetStyle getStyle() {
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    protected List<Widget> getWidgets() {
        ArrayList<Widget> result = new ArrayList<Widget>();
        for (WidgetInfo widgetInfo : this.widgets) {
            if (!widgetInfo.visible) continue;
            if (widgetInfo.label != null) {
                result.add(widgetInfo.label);
            }
            result.add(widgetInfo.widget);
        }
        return result;
    }

    private static class WidgetInfo {
        private Widget widget;
        private TextLabel label;
        private boolean visible;

        public WidgetInfo(Widget widget) {
            this.widget = widget;
            this.visible = true;
        }
    }
}

