/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.tool.CommandLineTool;
import nl.colorize.util.LogHelper;
import nl.colorize.util.swing.Utils2D;
import org.kohsuke.args4j.Option;

public class ColorConversionTool
extends CommandLineTool {
    @Option(name="-input", required=true, usage="Input directory containing the source images")
    public File inputDir;
    @Option(name="-output", required=true, usage="Output directory for generated results")
    public File outputDir;
    @Option(name="-alpha", required=true, usage="Alpha channel color in the format #000000")
    public String alphaChannel;
    private static final Color REAL_ALPHA = new Color(0, 0, 0, 0);
    private static final Logger LOGGER = LogHelper.getLogger(ColorConversionTool.class);

    public static void main(String[] args) {
        ColorConversionTool tool = new ColorConversionTool();
        tool.start(args);
    }

    @Override
    public void run() {
        this.outputDir.mkdir();
        try {
            List imageFiles = Files.walk(this.inputDir.toPath(), new FileVisitOption[0]).map(path -> path.toFile()).filter(file -> this.isImageFile((File)file)).collect(Collectors.toList());
            for (File imageFile : imageFiles) {
                LOGGER.info("Converting image " + imageFile.getName());
                this.convertImage(imageFile);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error while converting images", e);
        }
    }

    private boolean isImageFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        return file.getName().endsWith(".png") || file.getName().endsWith(".jpg");
    }

    private void convertImage(File file) throws IOException {
        File outputFile = new File(this.outputDir, file.getName());
        Preconditions.checkState((!outputFile.exists() ? 1 : 0) != 0, (Object)("Output file already exists: " + outputFile.getAbsolutePath()));
        BufferedImage originalImage = Utils2D.loadImage((File)file);
        BufferedImage result = this.convertImage(originalImage);
        Utils2D.savePNG((BufferedImage)result, (File)outputFile);
    }

    private BufferedImage convertImage(BufferedImage original) {
        BufferedImage result = new BufferedImage(original.getWidth(), original.getHeight(), 2);
        Color alphaChannelColor = Utils2D.parseHexColor((String)this.alphaChannel);
        for (int x = 0; x < original.getWidth(); ++x) {
            for (int y = 0; y < original.getHeight(); ++y) {
                int rgb = original.getRGB(x, y);
                if (rgb == alphaChannelColor.getRGB()) {
                    rgb = REAL_ALPHA.getRGB();
                }
                result.setRGB(x, y, rgb);
            }
        }
        return result;
    }
}

