/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.graphics.SpriteSheet;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.java2d.AWTImage;
import nl.colorize.multimedialib.tool.CommandLineTool;
import nl.colorize.util.CSVRecord;
import nl.colorize.util.LogHelper;
import nl.colorize.util.swing.Utils2D;
import org.kohsuke.args4j.Option;

public class SpriteSheetPacker
extends CommandLineTool {
    @Option(name="-input", required=true, usage="Directory containing source images")
    public File inputDir;
    @Option(name="-outimage", required=true, usage="Generated image file location")
    public File outputImageFile;
    @Option(name="-outdata", required=true, usage="Generated metadata file location")
    public File outputDataFile;
    @Option(name="-metadata", required=true, usage="Metadata file format, either 'yaml' or 'csv'")
    public String metadataFormat;
    @Option(name="-size", required=true, usage="Width/height of the sprite sheet")
    public int size;
    @Option(name="-exclude", required=false, usage="Excludes all images beyond a certain size")
    public int excludeSize;
    private static final List<Integer> VALID_SIZES = ImmutableList.of((Object)32, (Object)64, (Object)128, (Object)256, (Object)512, (Object)1024, (Object)2048);
    private static final int PADDING = 1;
    private static final Logger LOGGER = LogHelper.getLogger(SpriteSheetPacker.class);

    public static void main(String[] args) {
        SpriteSheetPacker tool = new SpriteSheetPacker();
        tool.start(args);
    }

    @Override
    public void run() {
        Preconditions.checkArgument((boolean)VALID_SIZES.contains(this.size), (Object)("Invalid argument: " + this.size));
        LOGGER.info("Gathering images from directory " + this.inputDir.getAbsolutePath());
        Map<File, BufferedImage> images = this.gatherSourceImages();
        LOGGER.info("Creating sprite sheet from " + images.size() + " images");
        images.keySet().stream().sorted(Comparator.comparing(File::getName)).forEach(file -> LOGGER.info("- " + file.getName()));
        LOGGER.info("Creating sprite sheet from " + images.size() + " images");
        SpriteSheet spritesheet = this.packImages(images);
        try {
            Utils2D.savePNG((BufferedImage)((AWTImage)spritesheet.getImage()).getImage(), (File)this.outputImageFile);
            this.saveMetadata(spritesheet);
            LOGGER.info("Saved sprite sheet to " + this.outputImageFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new MediaException("Could not save sprite sheet", e);
        }
    }

    private Map<File, BufferedImage> gatherSourceImages() {
        try {
            HashMap<File, BufferedImage> images = new HashMap<File, BufferedImage>();
            Files.walk(this.inputDir.toPath(), new FileVisitOption[0]).map(path -> path.toFile()).filter(file -> !file.isDirectory() && this.isImageFile((File)file)).peek(file -> LOGGER.info("- " + file.getName())).forEach(file -> images.put((File)file, this.loadImage((File)file)));
            return images;
        }
        catch (IOException e) {
            throw new MediaException("Cannot load images from source directory");
        }
    }

    private boolean isImageFile(File file) {
        return file.getName().endsWith(".jpg") || file.getName().endsWith(".png");
    }

    private BufferedImage loadImage(File file) {
        try {
            return Utils2D.loadImage((File)file);
        }
        catch (IOException e) {
            throw new MediaException("Cannot load image " + file.getAbsolutePath(), e);
        }
    }

    private SpriteSheet packImages(Map<File, BufferedImage> images) {
        BufferedImage buffer = new BufferedImage(this.size, this.size, 2);
        Graphics2D g2 = Utils2D.createGraphics((BufferedImage)buffer, (boolean)true, (boolean)true);
        SpriteSheet spritesheet = new SpriteSheet(new AWTImage(buffer));
        int x = 1;
        int y = 1;
        int rowHeight = 0;
        for (File imageFile : this.prepareImages(images)) {
            BufferedImage image = images.get(imageFile);
            if (x + image.getWidth() > this.size) {
                x = 1;
                y += rowHeight + 2;
                rowHeight = 0;
            }
            Rect region = new Rect(x, y, image.getWidth(), image.getHeight());
            spritesheet.markRegion(this.getRelativePath(imageFile), region);
            g2.drawImage((Image)image, x, y, null);
            x = (int)((float)x + (region.getWidth() + 2.0f));
            rowHeight = Math.max(rowHeight, image.getHeight());
        }
        g2.dispose();
        return spritesheet;
    }

    private String getRelativePath(File imageFile) {
        return this.inputDir.toPath().relativize(imageFile.toPath()).toString();
    }

    private boolean isImageExcluded(BufferedImage image) {
        if (this.excludeSize > 0) {
            return image.getWidth() >= this.excludeSize || image.getHeight() >= this.excludeSize;
        }
        return image.getWidth() > this.size || image.getHeight() > this.size;
    }

    private Iterable<File> prepareImages(Map<File, BufferedImage> images) {
        ArrayList<File> excluded = new ArrayList<File>();
        for (Map.Entry<File, BufferedImage> entry : images.entrySet()) {
            if (!this.isImageExcluded(entry.getValue())) continue;
            LOGGER.info("Excluding image " + entry.getKey().getName());
            excluded.add(entry.getKey());
        }
        return images.keySet().stream().filter(file -> !excluded.contains(file)).sorted((a, b) -> ((BufferedImage)images.get(b)).getHeight() - ((BufferedImage)images.get(a)).getHeight()).collect(Collectors.toList());
    }

    private void saveMetadata(SpriteSheet spritesheet) throws IOException {
        if (this.metadataFormat.equals("yaml")) {
            this.saveMetadataYAML(spritesheet);
        } else if (this.metadataFormat.equals("csv")) {
            this.saveMetadataCSV(spritesheet);
        } else {
            throw new IllegalArgumentException("Unknown metadata format: " + this.metadataFormat);
        }
    }

    private void saveMetadataYAML(SpriteSheet spritesheet) throws IOException {
        try (PrintWriter writer = new PrintWriter(this.outputDataFile, Charsets.UTF_8.displayName());){
            for (String name : spritesheet.getRegionNames()) {
                Rect region = spritesheet.getRegion(name);
                writer.println("- name: " + name);
                writer.println("  x: " + Math.round(region.getX()));
                writer.println("  y: " + Math.round(region.getY()));
                writer.println("  width: " + Math.round(region.getWidth()));
                writer.println("  height: " + Math.round(region.getHeight()));
            }
        }
    }

    private void saveMetadataCSV(SpriteSheet spritesheet) throws IOException {
        ImmutableList headers = ImmutableList.of((Object)"name", (Object)"x", (Object)"y", (Object)"width", (Object)"height");
        ArrayList<CSVRecord> records = new ArrayList<CSVRecord>();
        ArrayList<String> regions = new ArrayList<String>();
        regions.addAll(spritesheet.getRegionNames());
        Collections.sort(regions);
        for (String region : regions) {
            Rect bounds = spritesheet.getRegion(region);
            ImmutableList cells = ImmutableList.of((Object)region, (Object)this.format(bounds.getX()), (Object)this.format(bounds.getY()), (Object)this.format(bounds.getWidth()), (Object)this.format(bounds.getHeight()));
            records.add(CSVRecord.create((List)cells, (String)";"));
        }
        try (PrintWriter writer = new PrintWriter(this.outputDataFile, Charsets.UTF_8.displayName());){
            writer.write(CSVRecord.toCSV(records, (List)headers));
        }
    }

    private String format(float coordinate) {
        return String.valueOf(Math.round(coordinate));
    }
}

