/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.renderer.Drawable;
import nl.colorize.multimedialib.renderer.GraphicsContext2D;
import nl.colorize.multimedialib.renderer.Updatable;
import nl.colorize.multimedialib.scene.Action;
import nl.colorize.multimedialib.scene.Effect;
import nl.colorize.multimedialib.scene.Timer;

public class ActionManager
implements Updatable,
Drawable {
    private List<Action> actions = new ArrayList<Action>();

    public void play(Action action) {
        this.actions.add(action);
    }

    public void play(Effect effect) {
        this.actions.add(effect);
    }

    public void play(Timer timer) {
        Action wrapper = Action.until(a -> timer.isCompleted()).onFrame(timer::update);
        this.actions.add(wrapper);
    }

    public void play(Updatable action) {
        Action wrapper = Action.indefinitely().onFrame(action::update);
        this.actions.add(wrapper);
    }

    public void cancelAll() {
        this.actions.clear();
    }

    @Override
    public void update(float deltaTime) {
        Action[] buffer;
        for (Action action : buffer = this.actions.toArray(new Action[0])) {
            action.update(deltaTime);
            if (!action.isCompleted()) continue;
            this.actions.remove(action);
        }
    }

    @Override
    public void render(GraphicsContext2D graphics) {
        for (Action action : this.actions) {
            if (!(action instanceof Drawable)) continue;
            Drawable graphic = (Drawable)((Object)action);
            graphic.render(graphics);
        }
    }
}

