/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.RotatingBuffer;
import nl.colorize.multimedialib.renderer.ApplicationData;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GraphicsContext2D;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.InternetAccess;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.RenderCallback;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.Stage;
import nl.colorize.multimedialib.scene.Effect;
import nl.colorize.multimedialib.scene.MediaManager;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.util.PlatformFamily;
import nl.colorize.util.Stopwatch;
import nl.colorize.util.animation.Interpolation;
import nl.colorize.util.animation.Timeline;

public final class Application
implements RenderCallback {
    private Renderer renderer;
    private MediaManager media;
    private Scene activeScene;
    private Scene requestedScene;
    private Stopwatch fpsTimer = new Stopwatch();
    private RotatingBuffer fpsBuffer = new RotatingBuffer(100);
    private RotatingBuffer frameTimeBuffer = new RotatingBuffer(100);
    private boolean orientationLock;
    private Effect orientationLockAnim;
    private static final int FPS_MEASUREMENT_BUFFER_SIZE = 100;
    private static final FilePointer ORIENTATION_LOCK_IMAGE = new FilePointer("orientation-lock.png");

    private Application() {
    }

    private void init() {
        this.media = new MediaManager(this.renderer.getMediaLoader());
        this.orientationLock = false;
        this.orientationLockAnim = this.initOrientationLockAnim();
    }

    private Effect initOrientationLockAnim() {
        Image orientationLockImage = this.getMediaLoader().loadImage(ORIENTATION_LOCK_IMAGE);
        Timeline timeline = new Timeline(Interpolation.EASE, true);
        timeline.addKeyFrame(0.0f, 100.0f);
        timeline.addKeyFrame(1.0f, 110.0f);
        timeline.addKeyFrame(2.0f, 100.0f);
        Effect effect = Effect.forImage(orientationLockImage, timeline);
        effect.modify(value -> effect.getTransform().setScale(Math.round(value.floatValue())));
        return effect;
    }

    @Override
    public void update(Renderer renderer, float deltaTime) {
        if (this.renderer == null) {
            this.renderer = renderer;
            this.init();
        }
        Stopwatch frameTimer = new Stopwatch();
        frameTimer.tick();
        this.updateFrame(deltaTime);
        long actualFrameTime = frameTimer.tick();
        this.frameTimeBuffer.add(actualFrameTime);
    }

    private void updateFrame(float deltaTime) {
        if (this.requestedScene != null) {
            if (this.activeScene != null) {
                this.activeScene.end(this);
            }
            if (this.renderer.getSupportedGraphicsMode() == GraphicsMode.ALL) {
                Stage stage = this.renderer.getStage();
                stage.clear();
            }
            this.activeScene = this.requestedScene;
            this.requestedScene = null;
            this.activeScene.start(this);
        }
        if (this.activeScene != null && this.isScreenOrientationSupported()) {
            this.activeScene.update(this, deltaTime);
        } else {
            this.orientationLockAnim.update(deltaTime);
        }
    }

    @Override
    public void render(Renderer renderer, GraphicsContext2D graphics) {
        long fpsValue = this.fpsTimer.tick();
        this.fpsBuffer.add(fpsValue);
        if (!this.isScreenOrientationSupported()) {
            this.drawOrientationLock(graphics);
            return;
        }
        if (this.activeScene != null) {
            this.activeScene.render(this, graphics);
        }
    }

    public void changeScene(Scene requestedScene) {
        Preconditions.checkState((this.requestedScene == null ? 1 : 0) != 0, (Object)("Another scene has already been requested: " + requestedScene));
        this.requestedScene = requestedScene;
    }

    public Scene getActiveScene() {
        return this.activeScene;
    }

    public void lockScreenOrientation() {
        this.orientationLock = true;
    }

    private boolean isScreenOrientationSupported() {
        if (!this.orientationLock) {
            return true;
        }
        Canvas canvas = this.renderer.getCanvas();
        return canvas.getWidth() > 0 && canvas.getWidth() > canvas.getHeight();
    }

    private void drawOrientationLock(GraphicsContext2D graphics) {
        Canvas canvas = this.getCanvas();
        this.orientationLockAnim.setPosition((float)canvas.getWidth() / 2.0f, (float)canvas.getHeight() / 2.0f);
        this.orientationLockAnim.render(graphics);
    }

    @Deprecated
    public Renderer getRenderer() {
        return this.renderer;
    }

    public Canvas getCanvas() {
        return this.renderer.getCanvas();
    }

    public Stage getStage() {
        return this.renderer.getStage();
    }

    public InputDevice getInputDevice() {
        return this.renderer.getInputDevice();
    }

    public MediaLoader getMediaLoader() {
        return this.renderer.getMediaLoader();
    }

    public MediaManager getMedia() {
        return this.media;
    }

    public ApplicationData getApplicationData(String appName) {
        return this.renderer.getApplicationData(appName);
    }

    public InternetAccess getInternetAccess() {
        return this.renderer.getInternetAccess();
    }

    public PlatformFamily getPlatform() {
        return this.renderer.getPlatform();
    }

    public String getDistributionChannel() {
        PlatformFamily platform = this.getPlatform();
        switch (platform) {
            case IOS: {
                return "App Store";
            }
            case ANDROID: {
                return "Google Play";
            }
            case MAC: {
                return "Mac App Store";
            }
            case TEAVM: {
                return "Web";
            }
        }
        return "Download";
    }

    public String getScreenSize() {
        Canvas canvas = this.renderer.getCanvas();
        int width = Math.round((float)canvas.getWidth() * canvas.getZoomLevel());
        int height = Math.round((float)canvas.getHeight() * canvas.getZoomLevel());
        return width + "x" + height;
    }

    public float getAverageFramerate() {
        return 1000.0f / this.fpsBuffer.getAverageValue();
    }

    public float getAverageFrameTime() {
        return this.frameTimeBuffer.getAverageValue();
    }

    @Deprecated
    public static Application start(Renderer renderer) {
        Application app = new Application();
        renderer.attach(app);
        renderer.start();
        return app;
    }

    public static void start(Renderer renderer, Scene initialScene) {
        Application app = new Application();
        app.changeScene(initialScene);
        renderer.attach(app);
        renderer.start();
    }
}

