/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.utils.AnimationController;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.math.Matrix4;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.graphics.AnimationInfo;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.PolygonMesh;
import nl.colorize.multimedialib.graphics.PolygonModel;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.renderer.Stage;
import nl.colorize.multimedialib.renderer.libgdx.GDXImage;
import nl.colorize.multimedialib.renderer.libgdx.GDXMediaLoader;

public class GDXStage
implements Stage {
    private PerspectiveCamera camera;
    private DirectionalLight light;
    private Environment environment;
    private GDXMediaLoader mediaLoader;
    private List<PolygonModel> models;
    private Map<PolygonModel, ModelInstance> modelInstances;
    private Map<PolygonModel, AnimationController> animationsPlaying;
    private static final int FIELD_OF_VIEW = 75;
    private static final float NEAR_PLANE = 1.0f;
    private static final float FAR_PLANE = 300.0f;
    private static final ColorRGB AMBIENT_LIGHT_COLOR = new ColorRGB(100, 100, 100);
    private static final ColorRGB DEFAULT_LIGHT_COLOR = new ColorRGB(200, 200, 200);
    private static final Point3D DEFAULT_LIGHT_POS = new Point3D(-1.0f, -0.8f, -0.2f);

    protected GDXStage(GDXMediaLoader mediaLoader) {
        this.mediaLoader = mediaLoader;
        this.models = new ArrayList<PolygonModel>();
        this.modelInstances = new HashMap<PolygonModel, ModelInstance>();
        this.animationsPlaying = new HashMap<PolygonModel, AnimationController>();
        this.initStage();
    }

    private void initStage() {
        this.camera = new PerspectiveCamera(75.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
        this.camera.position.set(10.0f, 10.0f, 10.0f);
        this.camera.lookAt(0.0f, 0.0f, 0.0f);
        this.camera.near = 1.0f;
        this.camera.far = 300.0f;
        this.camera.update();
        this.light = new DirectionalLight();
        this.changeLight(DEFAULT_LIGHT_COLOR, DEFAULT_LIGHT_POS);
        this.environment = new Environment();
        this.changeAmbientLight(AMBIENT_LIGHT_COLOR);
        this.environment.add(this.light);
    }

    @Override
    public void moveCamera(Point3D position, Point3D target) {
        this.camera.position.set(position.getX(), position.getY(), position.getZ());
        this.camera.up.set(0.0f, 1.0f, 0.0f);
        this.camera.lookAt(target.getX(), target.getY(), target.getZ());
        this.camera.update();
    }

    @Override
    public Point3D getCameraPosition() {
        return new Point3D(this.camera.position.x, this.camera.position.y, this.camera.position.z);
    }

    @Override
    public void changeAmbientLight(ColorRGB color) {
        this.environment.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, this.createColor(color)));
    }

    @Override
    public void changeLight(ColorRGB color, Point3D direction) {
        this.light.set(this.createColor(color), direction.getX(), direction.getY(), direction.getZ());
    }

    @Override
    public void add(PolygonModel model) {
        this.models.add(model);
        Model modelData = this.mediaLoader.getModelData(model.getMesh());
        ModelInstance modelInstance = new ModelInstance(modelData);
        this.modelInstances.put(model, modelInstance);
    }

    @Override
    public void remove(PolygonModel model) {
        this.models.remove(model);
        this.modelInstances.remove(model);
        this.animationsPlaying.remove(model);
    }

    @Override
    public void clear() {
        this.models.clear();
        this.modelInstances.clear();
        this.animationsPlaying.clear();
    }

    @Override
    public void playAnimation(PolygonModel model, AnimationInfo animation, boolean loop) {
        ModelInstance modelInstance = this.getModelInstance(model);
        int loopCount = loop ? Integer.MAX_VALUE : 1;
        AnimationController animationController = new AnimationController(modelInstance);
        animationController.animate(animation.getName(), loopCount, 1.0f, null, 0.0f);
        this.animationsPlaying.put(model, animationController);
    }

    protected PerspectiveCamera getCamera() {
        return this.camera;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public void update(float deltaTime) {
        this.camera.update();
        this.updateAnimations(deltaTime);
    }

    private void updateAnimations(float deltaTime) {
        ArrayList<PolygonModel> completedAnimations = new ArrayList<PolygonModel>();
        for (Map.Entry<PolygonModel, AnimationController> entry : this.animationsPlaying.entrySet()) {
            AnimationController animation = entry.getValue();
            animation.update(deltaTime);
            if (!this.isAnimationCompleted(animation)) continue;
            completedAnimations.add(entry.getKey());
        }
        for (PolygonModel key : completedAnimations) {
            this.animationsPlaying.remove(key);
        }
    }

    private boolean isAnimationCompleted(AnimationController animation) {
        return animation.current == null || animation.current.loopCount == 0;
    }

    protected List<ModelInstance> getModelDisplayList() {
        return this.models.stream().map(model -> this.syncModelInstance((PolygonModel)model)).collect(Collectors.toList());
    }

    private ModelInstance getModelInstance(PolygonModel model) {
        ModelInstance modelInstance = this.modelInstances.get(model);
        Preconditions.checkState((modelInstance != null ? 1 : 0) != 0, (Object)"Model instance not available");
        return modelInstance;
    }

    private ModelInstance syncModelInstance(PolygonModel model) {
        ModelInstance modelInstance = this.getModelInstance(model);
        Matrix4 transform = modelInstance.transform;
        transform.setToTranslation(model.getPosition().getX(), model.getPosition().getY(), model.getPosition().getZ());
        transform.rotate(model.getRotationX(), model.getRotationY(), model.getRotationZ(), model.getRotationAmount());
        transform.scale(model.getScaleX(), model.getScaleY(), model.getScaleZ());
        return modelInstance;
    }

    @Override
    public PolygonMesh createQuad(Point2D size, ColorRGB color) {
        return this.createBox(new Point3D(size.getX(), 0.001f, size.getY()), color);
    }

    @Override
    public PolygonMesh createQuad(Point2D size, Image texture) {
        return this.createBox(new Point3D(size.getX(), 0.001f, size.getY()), texture);
    }

    @Override
    public PolygonMesh createBox(Point3D size, ColorRGB color) {
        ModelBuilder modelBuilder = new ModelBuilder();
        Model model = modelBuilder.createBox(size.getX(), size.getY(), size.getZ(), this.createMaterial(color), 9L);
        return this.mediaLoader.registerMesh("box", model);
    }

    @Override
    public PolygonMesh createBox(Point3D size, Image texture) {
        ModelBuilder modelBuilder = new ModelBuilder();
        Model model = modelBuilder.createBox(size.getX(), size.getY(), size.getZ(), this.createMaterial((GDXImage)texture), 25L);
        return this.mediaLoader.registerMesh("box", model);
    }

    @Override
    public PolygonMesh createSphere(float diameter, ColorRGB color) {
        ModelBuilder modelBuilder = new ModelBuilder();
        Model model = modelBuilder.createSphere(diameter, diameter, diameter, 32, 32, this.createMaterial(color), 9L);
        return this.mediaLoader.registerMesh("sphere", model);
    }

    @Override
    public PolygonMesh createSphere(float diameter, Image texture) {
        ModelBuilder modelBuilder = new ModelBuilder();
        Model model = modelBuilder.createSphere(diameter, diameter, diameter, 32, 32, this.createMaterial((GDXImage)texture), 25L);
        return this.mediaLoader.registerMesh("sphere", model);
    }

    private Material createMaterial(ColorRGB color) {
        ColorAttribute colorAttr = ColorAttribute.createDiffuse((Color)this.mediaLoader.toColor(color));
        return new Material(new Attribute[]{colorAttr});
    }

    private Material createMaterial(GDXImage texture) {
        TextureAttribute colorAttr = TextureAttribute.createDiffuse((TextureRegion)texture.getTextureRegion());
        return new Material(new Attribute[]{colorAttr});
    }

    private Color createColor(ColorRGB rgb) {
        return new Color((float)rgb.getR() / 255.0f, (float)rgb.getG() / 255.0f, (float)rgb.getB() / 255.0f, 1.0f);
    }
}

