/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.graphics.AnimationInfo;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.PolygonMesh;
import nl.colorize.multimedialib.graphics.TTFont;
import nl.colorize.multimedialib.renderer.Audio;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.TeaAudio;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;

public class TeaMediaLoader
implements MediaLoader {
    private GraphicsMode graphicsMode;
    private Map<FilePointer, ProgressTracker> progressTrackers;
    private List<TeaImage> loadedImages;
    private int nextAudioId;
    private int nextFontId;
    private static final Splitter LINE_SPLITTER = Splitter.on((String)"\n").trimResults().omitEmptyStrings();

    public TeaMediaLoader(GraphicsMode graphicsMode) {
        this.graphicsMode = graphicsMode;
        this.progressTrackers = new LinkedHashMap<FilePointer, ProgressTracker>();
        this.loadedImages = new ArrayList<TeaImage>();
        this.nextAudioId = 1;
        this.nextFontId = 1;
    }

    public boolean checkLoadingProgress() {
        LinkedHashMap<FilePointer, ProgressTracker> remaining = new LinkedHashMap<FilePointer, ProgressTracker>();
        for (Map.Entry<FilePointer, ProgressTracker> entry : this.progressTrackers.entrySet()) {
            if (entry.getValue().isLoadingComplete()) continue;
            remaining.put(entry.getKey(), entry.getValue());
        }
        this.progressTrackers = remaining;
        return remaining.isEmpty();
    }

    @Override
    public Image loadImage(FilePointer file) {
        String id = String.valueOf(this.loadedImages.size() + 1);
        String normalizedFilePath = this.normalizeFilePath(file, false);
        Browser.loadImage(id, normalizedFilePath);
        TeaImage imagePointer = new TeaImage(id, file, null);
        this.loadedImages.add(imagePointer);
        this.progressTrackers.put(file, () -> Browser.getImageHeight(id) > 0.0f);
        return imagePointer;
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        String id = String.valueOf(this.nextAudioId);
        Browser.loadAudio(id, this.normalizeFilePath(file, false));
        ++this.nextAudioId;
        return new TeaAudio(id);
    }

    @Override
    public TTFont loadFont(FilePointer file, String family, int size, ColorRGB color, boolean bold) {
        String id = String.valueOf(this.nextFontId);
        Browser.loadFont(id, this.normalizeFilePath(file, false), family);
        ++this.nextFontId;
        return new TTFont(family, size, color, false);
    }

    @Override
    public PolygonMesh loadMesh(FilePointer file) {
        UUID id = UUID.randomUUID();
        PolygonMesh mesh = new PolygonMesh(id, file.getPath(), Collections.emptyList());
        ArrayList loadCount = new ArrayList();
        Browser.loadModel(id.toString(), file.getPath(), (names, durations) -> {
            for (int i = 0; i < names.length; ++i) {
                mesh.addAnimation(new AnimationInfo(names[i], durations[i]));
            }
            loadCount.add(String.valueOf(loadCount.size() + 1));
        });
        this.progressTrackers.put(file, () -> loadCount.size() > 0);
        return mesh;
    }

    @Override
    public String loadText(FilePointer file) {
        return Browser.loadTextResourceFile(this.normalizeFilePath(file, true));
    }

    @Override
    public boolean containsResourceFile(FilePointer file) {
        String fileEntry = file.getPath();
        if (fileEntry.indexOf(47) != -1) {
            fileEntry = fileEntry.substring(fileEntry.lastIndexOf(47) + 1);
        }
        for (FilePointer entry : this.loadResourceFileManifest()) {
            if (!entry.getPath().equals(fileEntry)) continue;
            return true;
        }
        return false;
    }

    private List<FilePointer> loadResourceFileManifest() {
        String manifest = this.loadText(new FilePointer("resource-file-manifest"));
        return LINE_SPLITTER.splitToList((CharSequence)manifest).stream().map(path -> new FilePointer((String)path)).collect(Collectors.toList());
    }

    private String normalizeFilePath(FilePointer file, boolean replaceDot) {
        String normalized = file.getPath();
        if (normalized.indexOf(47) != -1) {
            normalized = normalized.substring(normalized.lastIndexOf(47) + 1);
        }
        if (replaceDot) {
            normalized = normalized.replace(".", "_");
        }
        return normalized;
    }

    @FunctionalInterface
    private static interface ProgressTracker {
        public boolean isLoadingComplete();
    }
}

