/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import nl.colorize.multimedialib.renderer.Updatable;

public class Action
implements Updatable {
    private Predicate<Action> terminator;
    private List<Runnable> startCallbacks;
    private List<Consumer<Float>> frameCallbacks;
    private List<Runnable> completedCallbacks;
    private Action chained;
    private float time;
    private boolean started;
    private boolean completed;

    protected Action(Predicate<Action> terminator) {
        this.terminator = terminator;
        this.startCallbacks = new ArrayList<Runnable>();
        this.frameCallbacks = new ArrayList<Consumer<Float>>();
        this.completedCallbacks = new ArrayList<Runnable>();
        this.time = 0.0f;
        this.started = false;
        this.completed = false;
    }

    public Action onStart(Runnable callback) {
        this.startCallbacks.add(callback);
        return this;
    }

    public Action onFrame(Consumer<Float> callback) {
        this.frameCallbacks.add(callback);
        return this;
    }

    public Action onFrame(Runnable callback) {
        return this.onFrame((Float deltaTime) -> callback.run());
    }

    public Action onCompleted(Runnable callback) {
        this.completedCallbacks.add(callback);
        return this;
    }

    public Action chain(Action next) {
        Preconditions.checkState((this.chained == null ? 1 : 0) != 0, (Object)"Chained action already defined");
        this.chained = next;
        return this;
    }

    @Override
    public void update(float deltaTime) {
        if (!this.started) {
            this.started = true;
            this.startCallbacks.forEach(Runnable::run);
        }
        if (this.completed) {
            if (this.chained != null) {
                this.chained.update(deltaTime);
            }
        } else {
            this.time += deltaTime;
            this.frameCallbacks.forEach(callback -> callback.accept(Float.valueOf(deltaTime)));
            if (this.terminator.test(this)) {
                this.completed = true;
                this.completedCallbacks.forEach(Runnable::run);
            }
        }
    }

    public boolean isCompleted() {
        return this.completed && (this.chained == null || this.chained.isCompleted());
    }

    public boolean isActive() {
        return this.started && !this.isCompleted();
    }

    public static Action indefinitely() {
        return Action.until(action -> false);
    }

    public static Action timed(float duration) {
        Preconditions.checkArgument((duration > 0.0f ? 1 : 0) != 0, (Object)("Invalid duration: " + duration));
        return Action.until(action -> action.time >= duration);
    }

    public static Action until(Predicate<Action> terminator) {
        return new Action(terminator);
    }
}

